/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.PathTools;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import org.hjson.JsonObject;

public class TextureProperties {
    public final String fileName;
    public final String original;
    public final String background;
    public final String overlayPath;
    public final ResourceLocation overlayLocation;
    public final boolean shade;
    public final Optional<Float> threshold;
    private static final String DEFAULT_TEXTURE = "items/string";
    private static final String DEFAULT_MATCHER = "blocks/stone";

    public TextureProperties(ResourceLocation location, JsonObject json) {
        this(location, HjsonTools.getStringOr(json, "original", DEFAULT_TEXTURE), HjsonTools.getStringOr(json, "background", DEFAULT_MATCHER), HjsonTools.getBoolOr(json, "shade", true), HjsonTools.getFloat(json, "threshold"));
    }

    public TextureProperties(ResourceLocation location, String original, String background, boolean shade, Optional<Float> threshold) {
        this.original = TextureProperties.extract(original);
        this.background = TextureProperties.extract(background);
        this.shade = shade;
        this.fileName = TextureProperties.getFileName(location, shade);
        this.overlayPath = CommonMethods.f("assets/{}/textures/blocks/{}.png", "osv", this.fileName);
        this.overlayLocation = CommonMethods.osvLocation("blocks/" + this.fileName);
        this.threshold = threshold;
    }

    public static TextureProperties from(ResourceLocation location, JsonObject json) {
        return new TextureProperties(location, json);
    }

    private static String extract(String condensedPath) {
        ResourceLocation asRL = new ResourceLocation(condensedPath);
        return CommonMethods.f("/assets/{}/textures/{}.png", asRL.func_110624_b(), asRL.func_110623_a());
    }

    private static String getFileName(ResourceLocation location, boolean shade) {
        String fileName = CommonMethods.f("{}/{}_overlay", location.func_110624_b(), location.func_110623_a());
        if (shade && Cfg.BlocksCat.shadeOverlays) {
            return PathTools.ensureShaded(fileName);
        }
        return fileName;
    }
}

