/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.properties.BlockPropertiesHelper;
import com.personthecat.orestonevariants.properties.DropProperties;
import com.personthecat.orestonevariants.properties.TextureProperties;
import com.personthecat.orestonevariants.properties.WorldGenProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.Lazy;
import com.personthecat.orestonevariants.util.Reference;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import org.hjson.JsonArray;
import org.hjson.JsonObject;

public class OreProperties {
    public final String name;
    public final String oreLookup;
    public final Lazy<IBlockState> ore;
    public final BlockPropertiesHelper block;
    public final TextureProperties texture;
    public final List<WorldGenProperties> gen;
    public final Optional<List<DropProperties>> drops;
    public final Optional<ResourceLocation> advancement;
    public final JsonObject recipe;
    private static final String FOLDER = "osv/ores/";
    public static final File DIR = new File(CommonMethods.getConfigDir(), "osv/ores/");

    private OreProperties(ResourceLocation location, String oreLookup, JsonObject root, JsonObject block, JsonObject texture, JsonArray gen, Optional<JsonArray> drop) {
        this(location.func_110623_a(), oreLookup, BlockPropertiesHelper.from(block), TextureProperties.from(location, texture), WorldGenProperties.list(oreLookup, gen), drop.map(DropProperties::list), HjsonTools.getLocation(block, "advancement"), HjsonTools.getObjectOrNew(root, "recipe"));
    }

    private OreProperties(String name, String oreLookup, BlockPropertiesHelper block, TextureProperties texture, List<WorldGenProperties> gen, Optional<List<DropProperties>> drops, Optional<ResourceLocation> advancement, JsonObject recipe) {
        this.name = name;
        this.oreLookup = oreLookup;
        this.ore = new Lazy<Supplier<IBlockState>>(() -> CommonMethods.getBlockState(oreLookup).orElseThrow(() -> HjsonTools.noBlockNamed(oreLookup)));
        this.block = block;
        this.texture = texture;
        this.gen = gen;
        this.drops = drops;
        this.advancement = advancement;
        this.recipe = recipe;
    }

    public static OreProperties fromJson(JsonObject json) {
        String name = HjsonTools.getString(json, "name").orElseThrow(() -> CommonMethods.runEx("missing name"));
        String mod = HjsonTools.getString(json, "mod").orElseThrow(() -> CommonMethods.runEx("missing mod"));
        ResourceLocation location = new ResourceLocation(mod, name);
        JsonObject block = HjsonTools.getObjectOrNew(json, "block");
        JsonObject texture = HjsonTools.getObjectOrNew(json, "texture");
        JsonArray gen = HjsonTools.getArrayOrNew(json, "gen");
        Optional<JsonArray> drop = HjsonTools.getArray(json, "loot");
        String lookup = HjsonTools.getStringOr(block, "location", "air");
        return new OreProperties(location, lookup, json, block, texture, gen, drop);
    }

    private static Optional<JsonObject> tryLoadFile(File f) {
        CommonMethods.info("Checking: {}", f.getName());
        JsonObject root = HjsonTools.readJson(f).orElseThrow(() -> CommonMethods.runExF("Invalid hjson file: {}.", f.getPath()));
        String mod = HjsonTools.getStringOr(root, "mod", "custom");
        String name = HjsonTools.getString(root, "name").orElseGet(() -> CommonMethods.noExtension(f)).toLowerCase();
        if (!Cfg.oreEnabled(name) || Cfg.modFamiliar(mod) && !Cfg.modEnabled(mod)) {
            CommonMethods.info("Skipping {}. It is supported, but not enabled", name);
            return CommonMethods.empty();
        }
        CommonMethods.info("Loading new ore properties: {}", name);
        root.set("name", name).set("mod", mod);
        return CommonMethods.full(root);
    }

    public static Set<OreProperties> setupOreProperties() {
        HashSet<OreProperties> properties = new HashSet<OreProperties>();
        for (File f : SafeFileIO.safeListFiles(DIR)) {
            if (!Reference.VALID_EXTENSIONS.contains(CommonMethods.extension(f)) || f.getName().equals("TUTORIAL.hjson")) continue;
            OreProperties.tryLoadFile(f).map(OreProperties::fromJson).ifPresent(properties::add);
        }
        return properties;
    }

    public static Optional<OreProperties> of(String name) {
        return CommonMethods.find(Main.ORE_PROPERTIES, props -> props.name.equals(name));
    }

    public static Set<OreProperties> of(String ... names) {
        return Stream.of(names).map(name -> OreProperties.of(name).orElseThrow(() -> CommonMethods.runExF("There are no properties named \"{}.\" Fix your property group.", name))).collect(Collectors.toSet());
    }
}

