/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.io;

import com.personthecat.orestonevariants.io.FileSpec;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.unsafe.Result;
import com.personthecat.orestonevariants.util.unsafe.Void;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.fml.common.Loader;

public class ZipTools {
    private static final String DIR = CommonMethods.f("{}/{}/", Loader.instance().getConfigDir(), "osv");
    private static final String NAME = "resources.zip";
    public static final File RESOURCE_PACK = new File(DIR, "resources.zip");
    private static final String RP_JAR_PATH = CommonMethods.f("/assets/{}/{}", "osv", "resources.zip");

    public static void copyResourcePack() {
        if (!RESOURCE_PACK.exists()) {
            SafeFileIO.mkdirs(RESOURCE_PACK.getParentFile()).expectF("Unable to create {}.", RESOURCE_PACK.getParentFile().getPath());
            SafeFileIO.copyStream(SafeFileIO.getRequiredResource(RP_JAR_PATH), RESOURCE_PACK.getPath()).expect("Unable to copy resource pack from the jar.");
        }
    }

    public static boolean rpContains(String path) {
        return ZipTools.fileInZip(RESOURCE_PACK, path);
    }

    public static Result<Void, IOException> createEmptyZip(File zip) {
        if (!zip.exists()) {
            return Result.with(() -> new ZipOutputStream(new FileOutputStream(zip))).of(zos -> {});
        }
        return Result.ok();
    }

    public static boolean fileInZip(File zip, String path) {
        return Result.with(() -> new ZipFile(zip)).of(zipFile -> zipFile.getEntry(path) != null).orElseGet(e -> false);
    }

    public static Set<String> getExistingPaths(File zip, FileSpec ... files) {
        return Result.with(() -> new ZipFile(zip)).of(zf -> ZipTools.getExistingPaths(zf, files)).orElseGet(e -> Collections.emptySet());
    }

    public static Set<String> getExistingPaths(ZipFile zip, FileSpec ... files) {
        return ZipTools.getPaths(files).filter(path -> zip.getEntry((String)path) != null).collect(Collectors.toSet());
    }

    private static Stream<String> getPaths(FileSpec ... files) {
        return Stream.of(files).map(spec -> spec.path);
    }

    public static Result<Boolean, IOException> copyToResources(FileSpec ... files) {
        return ZipTools.copyToZip(RESOURCE_PACK, false, files);
    }

    public static Result<Boolean, IOException> copyToZip(File zip, boolean allowReplace, FileSpec ... files) {
        Set<String> skip;
        Set<String> set = skip = allowReplace ? Collections.emptySet() : ZipTools.getExistingPaths(zip, files);
        if (skip.size() == files.length) {
            return Result.ok(true);
        }
        return ZipTools.doCopy(zip, skip, files);
    }

    private static Result<Boolean, IOException> doCopy(File zip, Set<String> skip, FileSpec ... files) {
        return Result.of(() -> {
            File tmp = SafeFileIO.moveReplace(zip, ZipTools.getTemporaryZip(RESOURCE_PACK.getParentFile())).throwIfErr();
            try (ZipFile tmpZip = new ZipFile(tmp);
                 ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));){
                ZipTools.copyOriginals(tmpZip, zos, skip);
                ZipTools.addFiles(zos, files);
            }
            return tmp.delete();
        });
    }

    private static File getTemporaryZip(File directory) throws IOException {
        return File.createTempFile("osv_", ".zip", directory);
    }

    private static void copyOriginals(ZipFile from, ZipOutputStream zos, Set<String> skip) {
        from.stream().filter(entry -> !skip.contains(entry.getName())).forEach(entry -> ZipTools.moveEntry(from, zos, entry).expect("Unrecoverable error when copying file to zip."));
    }

    private static void addFiles(ZipOutputStream zos, FileSpec ... files) throws IOException {
        for (FileSpec file : files) {
            ZipTools.moveToZip(file.is.get(), zos, new ZipEntry(file.path));
        }
    }

    private static Result<Void, IOException> moveEntry(ZipFile from, ZipOutputStream to, ZipEntry entry) {
        return Result.of(() -> ZipTools.moveToZip(from.getInputStream(entry), to, entry));
    }

    private static void moveToZip(InputStream is, ZipOutputStream zos, ZipEntry entry) throws IOException {
        zos.putNextEntry(entry);
        SafeFileIO.copyStream(is, zos, 1024).throwIfErr();
        is.close();
    }
}

