/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.config;

import com.google.common.collect.ImmutableMap;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.unsafe.ReflectionTools;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;
import org.hjson.JsonObject;

public class ModConfigSupport {
    private static final Map<String, SettingData> DATA = new ImmutableMap.Builder().put((Object)"iceandfire", (Object)new SettingData().set("generation|generateSapphireOre", false).set("generation|generateSilverOre", false)).put((Object)"AleXndr/simpleores", (Object)new SettingData().set("Ores.Copper Ore|enableOreGen", false).set("Ores.Tin Ore|enableOreGen", false).set("Ores.Mythril Ore|enableOreGen", false).set("Ores.Adamantium Ore|enableOreGen", false).set("Ores.Onyx Ore|enableOreGen", false)).put((Object)"MMDLib", (Object)new SettingData().set("general|using_orespawn", false).set("general|fallback_orespawn", false)).put((Object)"glasshearts", (Object)new SettingData().set("world|generateAgateOre", false).set("world|generateAmethystOre", false).set("world|generateOnyxOre", false).set("world|generateOpalOre", false).set("world|generateRubyOre", false).set("world|generateSapphireOre", false).set("world|generateTopazOre", false)).put((Object)"embers", (Object)new SettingData().set("compat|aluminumVeinsPerChunk", 0).set("ores|copperVeinsPerChunk", 0).set("ores|leadVeinsPerChunk", 0).set("compat|nickelVeinsPerChunk", 0).set("ores|quartzVeinsPerChunk", 0).set("ores|silverVeinsPerChunk", 0).set("compat|tinVeinsPerChunk", 0)).put((Object)"immersiveengineering", (Object)new SettingData().set("general.ores|ore_bauxite", 4, 40, 85, 0, 0).set("general.ores|ore_copper", 8, 40, 72, 0, 0).set("general.ores|ore_lead", 6, 8, 36, 0, 0).set("general.ores|ore_nickel", 6, 8, 24, 0, 0).set("general.ores|ore_uranium", 4, 8, 24, 0, 0)).put((Object)"thaumcraft_world", (Object)new SettingData().set("general|generateAmber", false).set("general|generateCinnabar", false).set("general|generateQuartz", false)).put((Object)"metallurgy_reforged/worldgen", (Object)new SettingData().set("ore_generation.adamantine|veinSize", 0).set("ore_generation.astralsilver|veinSize", 0).set("ore_generation.atlarus|veinSize", 0).set("ore_generation.carmot|veinSize", 0).set("ore_generation.copper|veinSize", 0).set("ore_generation.deepiron|veinSize", 0).set("ore_generation.infuscolium|veinSize", 0).set("ore_generation.lutetium|veinSize", 0).set("ore_generation.manganese|veinSize", 0).set("ore_generation.mithril|veinSize", 0).set("ore_generation.oureclase|veinSize", 0).set("ore_generation.orichalcum|veinSize", 0).set("ore_generation.osmium|veinSize", 0).set("ore_generation.phosphorite|veinSize", 0).set("ore_generation.platinum|veinSize", 0).set("ore_generation.potash|veinSize", 0).set("ore_generation.prometheum|veinSize", 0).set("ore_generation.rubracium|veinSize", 0).set("ore_generation.silver|veinSize", 0).set("ore_generation.sulfur|veinSize", 0).set("ore_generation.tin|veinSize", 0).set("ore_generation.zinc|veinSize", 0).set("ore_generation.alduorite|veinSize", 0).set("ore_generation.ceruclase|veinSize", 0).set("ore_generation.ignatius|veinSize", 0).set("ore_generation.kalendrite|veinSize", 0).set("ore_generation.lemurite|veinSize", 0).set("ore_generation.midasium|veinSize", 0).set("ore_generation.sanguinite|veinSize", 0).set("ore_generation.shadowiron|veinSize", 0).set("ore_generation.vulcanite|veinSize", 0).set("ore_generation.vyroxeres|veinSize", 0).set("ore_generation.eximite|veinSize", 0).set("ore_generation.meutoite|veinSize", 0)).put((Object)"undergroundbiomes", (Object)new SettingData().set("content|UBifyOres", false)).build();
    private static final Map<String, String> DATA_ALIASES = new ImmutableMap.Builder().put((Object)"simpleores", (Object)"AleXndr/simpleores").put((Object)"modernmetals", (Object)"MMDLib").put((Object)"basemetals", (Object)"MMDLib").put((Object)"mmdlib", (Object)"MMDLib").put((Object)"thaumcraft", (Object)"thaumcraft_world").put((Object)"metallurgy", (Object)"metallurgy_reforged/worldgen").put((Object)"ubc", (Object)"undergroundbiomes").put((Object)"undergroundbiomesconstructs", (Object)"undergroundbiomes").build();
    private static final File BOP_PARENT = new File(CommonMethods.getConfigDir() + "/biomesoplenty/biomes");
    private static final File BOP_MAIN = new File(BOP_PARENT + "/defaults/biomesoplenty");
    private static final File BOP_VANILLA = new File(BOP_PARENT + "/defaults/vanilla");
    private static final List<String> BOP_NAMES = CommonMethods.list("emeralds", "amber", "malachite", "peridot", "ruby", "sapphire", "tanzanite", "topaz", "amethyst");
    private static final Map<String, Configuration> CONFIGS = (Map)ReflectionTools.getValue(ConfigManager.class, "CONFIGS", null);

    private static String getCfgName(String mod) {
        mod = mod.toLowerCase();
        Optional<String> alias = CommonMethods.safeGet(DATA_ALIASES, mod);
        return alias.orElse(mod);
    }

    private static Configuration getConfig(String mod) {
        File cfg = new File(CommonMethods.f("{}/{}.cfg", CommonMethods.getConfigDir(), mod));
        return CommonMethods.safeGet(CONFIGS, cfg.getAbsolutePath()).orElse(new Configuration(cfg));
    }

    public static boolean updateConfig(String mod) {
        String cfgName = ModConfigSupport.getCfgName(mod);
        if (cfgName.equals("all")) {
            DATA.forEach((name, data) -> data.doUpdates(ModConfigSupport.getConfig(name)));
            return ModConfigSupport.doBOP();
        }
        if (cfgName.equals("biomesoplenty")) {
            return ModConfigSupport.doBOP();
        }
        Optional<SettingData> settings = CommonMethods.safeGet(DATA, cfgName);
        Configuration config = ModConfigSupport.getConfig(cfgName);
        settings.ifPresent(s -> s.doUpdates(config));
        return settings.isPresent();
    }

    private static boolean doBOP() {
        if (!BOP_PARENT.exists()) {
            return false;
        }
        for (File preset : ModConfigSupport.getBopFiles()) {
            JsonObject json = HjsonTools.readJson(preset).orElseThrow(() -> CommonMethods.runExF("Error parsing BOP preset: {}", preset.getName()));
            JsonObject generators = HjsonTools.getObject(json, "generators").orElseThrow(() -> CommonMethods.runExF("Invalid BOP preset: {}. No generators specified.", preset.getName()));
            for (JsonObject ore : ModConfigSupport.getOreGenerators(generators)) {
                ore.set("enable", false);
            }
            File custom = new File(BOP_PARENT, preset.getName());
            HjsonTools.writeJson(json, custom).expectF("Unable to write custom preset: {}", custom);
        }
        return true;
    }

    private static List<File> getBopFiles() {
        List<File> defaults = CommonMethods.list(SafeFileIO.safeListFiles(BOP_MAIN));
        defaults.addAll(CommonMethods.list(SafeFileIO.safeListFiles(BOP_VANILLA)));
        ArrayList<File> files = new ArrayList<File>();
        for (File f : defaults) {
            File custom = new File(BOP_PARENT, f.getName());
            files.add(custom.exists() ? custom : f);
        }
        return files;
    }

    private static List<JsonObject> getOreGenerators(JsonObject generators) {
        ArrayList<JsonObject> ores = new ArrayList<JsonObject>();
        for (String key : BOP_NAMES) {
            HjsonTools.getObject(generators, key).ifPresent(ores::add);
        }
        return ores;
    }

    private static class SettingData {
        final List<Pair<String, Boolean>> bools = new ArrayList<Pair<String, Boolean>>();
        final List<Pair<String, Integer>> ints = new ArrayList<Pair<String, Integer>>();
        final List<Pair<String, int[]>> intArrays = new ArrayList<Pair<String, int[]>>();

        private SettingData() {
        }

        SettingData set(String field, boolean val) {
            this.bools.add((Pair<String, Boolean>)Pair.of((Object)field, (Object)val));
            return this;
        }

        SettingData set(String field, int val) {
            this.ints.add((Pair<String, Integer>)Pair.of((Object)field, (Object)val));
            return this;
        }

        SettingData set(String field, int ... val) {
            this.intArrays.add((Pair<String, int[]>)Pair.of((Object)field, (Object)val));
            return this;
        }

        void doUpdates(Configuration config) {
            String[] split;
            for (Pair<String, Boolean> pair : this.bools) {
                split = ((String)pair.getKey()).split("\\|");
                boolean b = (Boolean)pair.getValue();
                config.get(split[0], split[1], b).set(b);
            }
            for (Pair pair : this.ints) {
                split = ((String)pair.getKey()).split("\\|");
                int i = (Integer)pair.getValue();
                config.get(split[0], split[1], i).set(i);
            }
            for (Pair pair : this.intArrays) {
                split = ((String)pair.getKey()).split("\\|");
                int[] ints = (int[])pair.getValue();
                config.get(split[0], split[1], ints).set(ints);
            }
            config.save();
        }
    }
}

