/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.gui;

import galaxyspace.GalaxySpace;
import galaxyspace.api.IResearch;
import galaxyspace.core.client.gui.tile.GuiTileBase;
import galaxyspace.core.handler.capabilities.GSStatsCapabilityClient;
import galaxyspace.core.handler.capabilities.StatsCapabilityClient;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.util.researches.ResearchUtil;
import galaxyspace.systems.SolarSystem.planets.overworld.inventory.ContainerResearchTable;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityResearchTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiResearchTable
extends GuiTileBase {
    private final TileEntityResearchTable tile;
    private static final ResourceLocation iconsTexture = new ResourceLocation("galaxyspace", "textures/gui/researches/research_icons.png");
    public List<IResearch> know_res = new ArrayList<IResearch>();

    public GuiResearchTable(InventoryPlayer inventoryPlayer, TileEntityResearchTable tileEntity) {
        super(new ContainerResearchTable(inventoryPlayer, tileEntity), -1, -1);
        this.tile = tileEntity;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateRes();
    }

    private void updateRes() {
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
    }

    public void func_73863_a(int mousePosX, int mousePosY, float partialTicks) {
        super.func_73863_a(mousePosX, mousePosY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        for (IResearch res : ResearchUtil.getReserachList()) {
            int x = containerWidth + res.getPosX() * 6;
            int y = containerHeight + res.getPosY() * 3;
            if (mouseX < x || mouseX >= x + 25 || mouseY < y || mouseY >= y + 25) continue;
            if (button == 0) {
                GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_UPDATE_RESEARCH_USER, (World)this.field_146297_k.field_71441_e, new Object[]{res.getID()}));
                continue;
            }
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_UPDATE_RESEARCH_USER, (World)this.field_146297_k.field_71441_e, new Object[]{-1}));
        }
    }

    private void drawWindow(int posX, int posY, float ticks, IResearch res, int mousePosX, int mousePosY) {
        boolean isResearched = false;
        this.field_146297_k.field_71446_o.func_110577_a(iconsTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StatsCapabilityClient gs_stats = GSStatsCapabilityClient.get((Entity)this.field_146297_k.field_71439_g);
        int x = res.getTextureID();
        int y = res.getTextureID() / 8;
        if (res.getTextureID() > 8 * (y + 1)) {
            x = 8 * y - res.getTextureID() + 1;
        }
        GuiResearchTable.func_152125_a((int)(posX + 16), (int)(posY - 16), (float)(32 * x), (float)(32 * y), (int)32, (int)32, (int)24, (int)24, (float)256.0f, (float)256.0f);
        for (int i : gs_stats.getKnowledgeResearches()) {
            if (i != res.getID()) continue;
            isResearched = true;
        }
        if (isResearched) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        this.field_146289_q.func_78279_b(res.getName(), posX + 30 - this.field_146289_q.func_78256_a(res.getName()) / 2, posY + 10, 180, 0xFFFFFF);
        this.field_146289_q.func_78279_b(res.getNeedExperience() + " EXP", posX + 30 - this.field_146289_q.func_78256_a(res.getNeedExperience() + " EXP") / 2, posY + 20, 180, 0xFFFFFF);
        if (!isResearched && mousePosX >= posX + 15 && mousePosX < posX + 40 && mousePosY >= posY - 15 && mousePosY < posY + 10) {
            int i = 0;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
            this.drawToolTip(mousePosX + 18, mousePosY + 20, "", res.getNeedItems().size() * 18 + 100, 25);
            this.field_146289_q.func_78276_b("Need Items:", mousePosX - 10, mousePosY + 8, 0xFFFFFF);
            for (ItemStack s : res.getNeedItems()) {
                RenderHelper.func_74520_c();
                this.field_146297_k.func_175599_af().func_180450_b(s, mousePosX + i * 18 - 35, mousePosY + 16);
                RenderHelper.func_74518_a();
                ++i;
            }
            GL11.glPopMatrix();
        }
    }

    private void drawToolTip(int mousePosX, int mousePosY, String tooltip) {
        this.drawToolTip(mousePosX, mousePosY, tooltip, this.field_146289_q.func_78256_a(tooltip), 8);
    }

    private void drawToolTip(int mousePosX, int mousePosY, String tooltip, int width, int height) {
        GL11.glPushMatrix();
        int k = width;
        int j2 = mousePosX - k / 2;
        int k2 = mousePosY - 12;
        int i1 = height;
        if (j2 + k > this.field_146294_l) {
            j2 -= j2 - this.field_146294_l + k;
        }
        if (k2 + i1 + 6 > this.field_146295_m) {
            k2 = this.field_146295_m - i1 - 6;
        }
        int j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)94, (int)153);
        this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
        this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
        this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
        this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
        int k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
        this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
        this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
        this.field_146289_q.func_78279_b(tooltip, j2, k2, 150, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        GL11.glPopMatrix();
    }

    @Override
    protected boolean isModuleSupport() {
        return false;
    }

    @Override
    protected String getName() {
        return this.tile.func_70005_c_();
    }

    @Override
    protected Slot getBatterySlot() {
        return null;
    }
}

