/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.gui;

import galaxyspace.GalaxySpace;
import galaxyspace.core.GSItems;
import galaxyspace.core.client.gui.tile.GuiTileBase;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.inventory.ContainerLiquidExtractor;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidExtractor;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLiquidExtractor
extends GuiTileBase {
    private TileEntityLiquidExtractor tileEntity;
    private GuiElementInfoRegion fuelTankRegion;

    public GuiLiquidExtractor(InventoryPlayer par1InventoryPlayer, TileEntityLiquidExtractor tileEntity) {
        super(new ContainerLiquidExtractor(par1InventoryPlayer, tileEntity), 2, 1);
        this.fuelTankRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 28, 16, 38, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.tileEntity = tileEntity;
        this.field_147000_g = 190;
        this.moduleInfoX = this.field_147002_h.func_75147_a((IInventory)tileEntity, (int)3).field_75223_e;
        this.moduleInfoY = this.field_147002_h.func_75147_a((IInventory)tileEntity, (int)3).field_75221_f;
        this.moduleList = new ItemStack[]{new ItemStack(GSItems.UPGRADES, 1, 0), new ItemStack(GSItems.UPGRADES, 1, 3)};
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        int fuelLevel = this.tileEntity.waterTank != null && this.tileEntity.waterTank.getFluid() != null ? this.tileEntity.waterTank.getFluid().amount : 0;
        int fuelCapacity = this.tileEntity.waterTank != null ? this.tileEntity.waterTank.getCapacity() : 0;
        fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + fuelLevel + " / " + fuelCapacity);
        this.fuelTankRegion.tooltipStrings = fuelTankDesc;
        this.fuelTankRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 80;
        this.fuelTankRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 20;
        this.fuelTankRegion.parentWidth = this.field_146294_l;
        this.fuelTankRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.fuelTankRegion);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String displayText = this.tileEntity.processTicks > 0 ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.running.name") : EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.idle.name");
        TextFormatting color = this.getStyle() == GuiTileBase.Style.MODERN ? TextFormatting.WHITE : TextFormatting.DARK_GRAY;
        String str = color + GCCoreUtil.translate((String)"gui.message.status.name") + ": " + displayText;
        this.field_146289_q.func_78276_b(str, 135 - this.field_146289_q.func_78256_a(str) / 2, 84, 0x404040);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        int fuelCapacity;
        super.func_146976_a(par1, par2, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(containerWidth + 45, containerHeight + 36, 221, 87, 22, 22);
        this.func_73729_b(containerWidth + 45, containerHeight + 56, 221, 87, 22, 22);
        this.func_73729_b(containerWidth + 105, containerHeight + 36, 221, 87, 22, 22);
        this.func_73729_b(containerWidth + 105, containerHeight + 56, 221, 87, 22, 22);
        this.renderEnergyBar(containerWidth + 30, containerHeight + 84, this.tileEntity.getScaledElecticalLevel(55), this.tileEntity.getEnergyStoredGC(), this.tileEntity.getMaxEnergyStoredGC());
        this.func_73729_b(containerWidth + this.field_146999_f / 2 - 20, containerHeight + 18, 180, 67, 20, 42);
        FluidStack fluid = this.tileEntity.waterTank.getFluid();
        if (fluid != null) {
            GSUtils.displayGauge(containerWidth + this.field_146999_f / 2 - 19, containerHeight - 1, this.tileEntity.getScaledTankLevel(38), this.tileEntity.waterTank.getFluid(), 0);
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.getTexture());
        this.func_73729_b(containerWidth + this.field_146999_f / 2 - 20, containerHeight + 18, 200, 67, 16, 42);
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        int fuelLevel = this.tileEntity.waterTank != null && this.tileEntity.waterTank.getFluid() != null ? this.tileEntity.waterTank.getFluid().amount : 0;
        int n = fuelCapacity = this.tileEntity.waterTank != null ? this.tileEntity.waterTank.getCapacity() : 0;
        if (fluid != null) {
            fuelTankDesc.add(EnumColor.YELLOW + this.tileEntity.waterTank.getFluid().getLocalizedName() + ": " + fuelLevel + " / " + fuelCapacity);
        }
        this.fuelTankRegion.tooltipStrings = fuelTankDesc;
        if (GalaxySpace.debug) {
            GSUtils.renderDebugGui((GuiContainer)this, containerWidth, containerHeight);
        }
    }

    @Override
    protected boolean isModuleSupport() {
        return true;
    }

    @Override
    protected String getName() {
        return this.tileEntity.func_70005_c_();
    }

    @Override
    protected Slot getBatterySlot() {
        return this.field_147002_h.func_75147_a((IInventory)this.tileEntity, 0);
    }
}

