/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.integration.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.RecyclerRecipes;

public class ActionRecyclerRecipes {

    static class Remove
    implements IAction {
        private final IItemStack stack;

        public Remove(IItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            RecyclerRecipes.recycling().removeRecipe(CraftTweakerMC.getItemStack((IItemStack)this.stack));
        }

        public String describe() {
            return "Removed Recycler recipe for " + this.stack;
        }
    }

    static class Add
    implements IAction {
        private final IItemStack stack;
        private final IItemStack result;
        private final ILiquidStack liquid;
        private final int chance;

        public Add(IItemStack stack, IItemStack result, ILiquidStack liquid, int chances) {
            this.stack = stack;
            this.result = result;
            this.liquid = liquid;
            this.chance = chances;
        }

        public void apply() {
            RecyclerRecipes.recycling().addNewRecipe(CraftTweakerMC.getItemStack((IItemStack)this.stack), CraftTweakerMC.getItemStack((IItemStack)this.result), this.chance, CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid));
        }

        public String describe() {
            return "Added Recycler recipe for " + this.liquid;
        }
    }
}

