/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.moreplanetsextras.spaceStations;

import com.mjr.moreplanetsextras.Config;
import com.mjr.moreplanetsextras.spaceStations.WorldProviderOrbitChalos;
import com.mjr.moreplanetsextras.spaceStations.WorldProviderOrbitDiona;
import com.mjr.moreplanetsextras.spaceStations.WorldProviderOrbitNibiru;
import java.util.HashMap;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOrbit;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpaceStationsMain {
    public static Satellite dionaSpaceStation;
    public static Satellite chalosSpaceStation;
    public static Satellite nibiruSpaceStation;

    public static void init() {
        SpaceStationsMain.initializeSatellites();
        SpaceStationsMain.registerSatellites();
        SpaceStationsMain.registerSatellitesRecipes();
    }

    private static void initializeSatellites() {
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.diona") != null && Config.dionaSpaceStation) {
            dionaSpaceStation = new Satellite("spacestation.diona").setParentBody((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.diona"));
            dionaSpaceStation.setRelativeSize(0.2667f);
            dionaSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            dionaSpaceStation.setRelativeOrbitTime(20.0f);
            dionaSpaceStation.setTierRequired(((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.diona")).getTierRequirement());
            dionaSpaceStation.setDimensionInfo(Config.dionaSpaceStationID, Config.dionaSpaceStationStaticID, WorldProviderOrbitDiona.class);
            dionaSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        }
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.chalos") != null && Config.chalosSpaceStation) {
            chalosSpaceStation = new Satellite("spacestation.chalos").setParentBody((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.chalos"));
            chalosSpaceStation.setRelativeSize(0.2667f);
            chalosSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            chalosSpaceStation.setRelativeOrbitTime(20.0f);
            chalosSpaceStation.setTierRequired(((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.chalos")).getTierRequirement());
            chalosSpaceStation.setDimensionInfo(Config.chalosSpaceStationID, Config.chalosSpaceStationStaticID, WorldProviderOrbitChalos.class);
            chalosSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        }
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.nibiru") != null && Config.nibiruSpaceStation) {
            nibiruSpaceStation = new Satellite("spacestation.nibiru").setParentBody((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.nibiru"));
            nibiruSpaceStation.setRelativeSize(0.2667f);
            nibiruSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            nibiruSpaceStation.setRelativeOrbitTime(20.0f);
            nibiruSpaceStation.setTierRequired(((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.nibiru")).getTierRequirement());
            nibiruSpaceStation.setDimensionInfo(Config.nibiruSpaceStationID, Config.nibiruSpaceStationStaticID, WorldProviderOrbitNibiru.class);
            nibiruSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        }
    }

    private static void registerSatellites() {
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.diona") != null && Config.dionaSpaceStation) {
            GalaxyRegistry.registerSatellite((Satellite)dionaSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderOrbitDiona.class, (ITeleportType)new TeleportTypeOrbit());
            GalacticraftRegistry.registerDimension((String)"Diona Space Station", (String)"_diona_orbit", (int)Config.dionaSpaceStationID, WorldProviderOrbitDiona.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Diona Space Station", (String)"_diona_orbit", (int)Config.dionaSpaceStationStaticID, WorldProviderOrbitDiona.class, (boolean)true);
        }
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.chalos") != null && Config.chalosSpaceStation) {
            GalaxyRegistry.registerSatellite((Satellite)chalosSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderOrbitChalos.class, (ITeleportType)new TeleportTypeOrbit());
            GalacticraftRegistry.registerDimension((String)"Chalos Space Station", (String)"_chalos_orbit", (int)Config.chalosSpaceStationID, WorldProviderOrbitChalos.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Chalos Space Station", (String)"_chalos_orbit", (int)Config.chalosSpaceStationStaticID, WorldProviderOrbitChalos.class, (boolean)true);
        }
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.nibiru") != null && Config.nibiruSpaceStation) {
            GalaxyRegistry.registerSatellite((Satellite)nibiruSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderOrbitNibiru.class, (ITeleportType)new TeleportTypeOrbit());
            GalacticraftRegistry.registerDimension((String)"Nibiru Space Station", (String)"_nibiru_orbit", (int)Config.nibiruSpaceStationID, WorldProviderOrbitNibiru.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Nibiru Space Station", (String)"_nibiru_orbit", (int)Config.nibiruSpaceStationStaticID, WorldProviderOrbitNibiru.class, (boolean)true);
        }
    }

    private static void registerSatellitesRecipes() {
        HashMap<ItemStack, Integer> inputMap = new HashMap<ItemStack, Integer>();
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.diona") != null && dionaSpaceStation != null) {
            inputMap = new HashMap();
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "diona_item")), 1, 0), 32);
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "diona_item")), 1, 1), 32);
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "diona_item")), 1, 4), 32);
            GalacticraftRegistry.registerSpaceStation((SpaceStationType)new SpaceStationType(Config.dionaSpaceStationID, ((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.diona")).getDimensionID(), new SpaceStationRecipe(inputMap)));
        }
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.chalos") != null && chalosSpaceStation != null) {
            inputMap = new HashMap();
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "chalos_item")), 1, 0), 32);
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "chalos_item")), 1, 1), 32);
            GalacticraftRegistry.registerSpaceStation((SpaceStationType)new SpaceStationType(Config.chalosSpaceStationID, ((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.chalos")).getDimensionID(), new SpaceStationRecipe(inputMap)));
        }
        if (GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.nibiru") != null && nibiruSpaceStation != null) {
            inputMap = new HashMap();
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "nibiru_item")), 1, 0), 32);
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "nibiru_item")), 1, 1), 32);
            inputMap.put(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("moreplanets", "nibiru_item")), 1, 2), 32);
            GalacticraftRegistry.registerSpaceStation((SpaceStationType)new SpaceStationType(Config.nibiruSpaceStationID, ((Planet)GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)"planet.nibiru")).getDimensionID(), new SpaceStationRecipe(inputMap)));
        }
    }
}

