/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.modules.galacticraft.features;

import java.util.Objects;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.romvoid95.api.config.IOrdered;
import net.romvoid95.api.feature.Feature;
import net.romvoid95.galactic.core.GCTLog;
import net.romvoid95.galactic.core.gc.IOWriter;
import net.romvoid95.galactic.modules.galacticraft.GalacticraftModuleConfig;

public class SpawnDimension
extends Feature
implements IOrdered {
    private CelestialBody spawnDim;

    public SpawnDimension() {
        this.category = "DimensionSpawn";
        this.categoryComment = "Set a certain Planet or Moon as a Spawn Point\n\nYou should have SPAWN-ITEMS Configured and set prior to enabling this setting\nAt the moment any moon or planet set to spawn in uses that bodies teleport system (spawns in the lander)";
    }

    @Override
    public void addProp() {
        this.propOrder.add(GalacticraftModuleConfig.SpawnDim.key());
        this.propOrder.add(GalacticraftModuleConfig.useCoord.key());
        this.propOrder.add(GalacticraftModuleConfig.firstJoinOnly.key());
        this.propOrder.add(GalacticraftModuleConfig.everyDeath.key());
        this.propOrder.add(GalacticraftModuleConfig.spawnPos.key());
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void postInit() {
        String idName = GalacticraftModuleConfig.SpawnDim.get().replace("_", " ");
        String err = "ERROR: Could not get Celestial Body for name: ";
        for (CelestialBody body : IOWriter.allBodies) {
            if (!body.getName().equalsIgnoreCase(idName)) continue;
            this.spawnDim = Objects.requireNonNull(GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)body.getTranslatedName()), err + idName);
        }
        GCTLog.debug("Spawn Dimension Set: " + this.spawnDim.getTranslatedName());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.handleLoggingEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (GalacticraftModuleConfig.everyDeath.get()) {
            this.handleRespawnEvent(event);
        }
    }

    private void handleLoggingEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayer) {
            EntityPlayer player = event.player;
            if (GalacticraftModuleConfig.firstJoinOnly.get()) {
                NBTTagCompound entityData = player.getEntityData();
                NBTTagCompound persistedData = entityData.func_74775_l("PlayerPersisted");
                entityData.func_74782_a("PlayerPersisted", (NBTBase)persistedData);
                String key = "galactictweaks:FirstSpawn";
                if (!persistedData.func_74767_n("galactictweaks:FirstSpawn")) {
                    this.teleport((EntityPlayerMP)player, this.spawnDim.getDimensionID());
                    persistedData.func_74757_a("galactictweaks:FirstSpawn", true);
                }
            } else if (!GalacticraftModuleConfig.firstJoinOnly.get()) {
                this.teleport((EntityPlayerMP)player, this.spawnDim.getDimensionID());
            }
        }
    }

    private void handleRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayer) {
            EntityPlayer player = event.player;
            this.teleport((EntityPlayerMP)player, this.spawnDim.getDimensionID());
        }
    }

    private void teleport(EntityPlayerMP player, int dimId) {
        BlockPos pos;
        MinecraftServer mcServer = player.func_184102_h();
        WorldServer world = mcServer.func_71218_a(dimId);
        String[] spawnString = GalacticraftModuleConfig.spawnPos.get().split(",");
        if (GalacticraftModuleConfig.useCoord.get()) {
            pos = new BlockPos(Integer.valueOf(spawnString[0]).intValue(), Integer.valueOf(spawnString[1]).intValue(), Integer.valueOf(spawnString[2]).intValue());
        } else {
            int y = world.func_175726_f(world.func_175694_M()).func_177433_f(world.func_175694_M());
            pos = new BlockPos(world.func_175694_M().func_177958_n(), y, world.func_175694_M().func_177952_p());
        }
        WorldUtil.teleportEntitySimple((World)world, (int)dimId, (EntityPlayerMP)player, (Vector3)new Vector3(pos));
    }

    @Override
    public boolean isEnabled() {
        return GalacticraftModuleConfig.SPAWN_DIMENSION;
    }
}

