/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.modules.galacticraft.features;

import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.romvoid95.api.config.IOrdered;
import net.romvoid95.api.feature.Feature;
import net.romvoid95.galactic.core.utils.ItemStackUtil;
import net.romvoid95.galactic.modules.galacticraft.GalacticraftModuleConfig;

public class OxygenSpawnGear
extends Feature
implements IOrdered {
    public OxygenSpawnGear() {
        this.category = "OxygenSpawnGear";
        this.categoryComment = "Allows Players to Spawn With Oxygen Items Equipped";
    }

    @Override
    public void addProp() {
        this.propOrder.add(GalacticraftModuleConfig.tanksValue.key());
        this.propOrder.add(GalacticraftModuleConfig.thermalArmor.key());
        this.propOrder.add(GalacticraftModuleConfig.includeThermals.key());
        this.propOrder.add(GalacticraftModuleConfig.includeParachute.key());
        this.propOrder.add(GalacticraftModuleConfig.includeFreqModule.key());
        this.propOrder.add(GalacticraftModuleConfig.includeShieldController.key());
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        boolean para = GalacticraftModuleConfig.includeParachute.get();
        boolean shield = GalacticraftModuleConfig.includeShieldController.get();
        boolean freq = GalacticraftModuleConfig.includeFreqModule.get();
        boolean therm = GalacticraftModuleConfig.includeThermals.get();
        EntityPlayer player = event.player;
        NBTTagCompound entityData = player.getEntityData();
        NBTTagCompound persistedData = entityData.func_74775_l("PlayerPersisted");
        entityData.func_74782_a("PlayerPersisted", (NBTBase)persistedData);
        String key = "galactictweaks:ReceivedOxygen";
        if (!persistedData.func_74767_n("galactictweaks:ReceivedOxygen")) {
            GCPlayerStats gcstats = (GCPlayerStats)event.player.getCapability(GCCapabilities.GC_STATS_CAPABILITY, null);
            InventoryExtended inv = new InventoryExtended();
            inv.func_70299_a(0, ItemStackUtil.itemStack(GCItems.oxMask));
            inv.func_70299_a(1, ItemStackUtil.itemStack(GCItems.oxygenGear));
            inv.func_70299_a(2, OxygenSpawnGear.setTanks());
            inv.func_70299_a(3, OxygenSpawnGear.setTanks());
            if (para) {
                inv.func_70299_a(4, ItemStackUtil.itemStack(GCItems.parachute));
            }
            if (shield) {
                inv.func_70299_a(10, ItemStackUtil.itemStack(VenusItems.basicItem, 0));
            }
            if (freq) {
                inv.func_70299_a(5, ItemStackUtil.itemStack(GCItems.basicItem, 19));
            }
            if (therm) {
                inv.func_70299_a(6, OxygenSpawnGear.setThermals(0));
                inv.func_70299_a(7, OxygenSpawnGear.setThermals(1));
                inv.func_70299_a(8, OxygenSpawnGear.setThermals(2));
                inv.func_70299_a(9, OxygenSpawnGear.setThermals(3));
            }
            gcstats.setExtendedInventory(inv);
            persistedData.func_74757_a("galactictweaks:ReceivedOxygen", true);
        }
    }

    private static ItemStack setTanks() {
        String val = GalacticraftModuleConfig.tanksValue.get();
        ItemStack tank = null;
        switch (val) {
            case "heavy": {
                tank = ItemStackUtil.itemStack(GCItems.oxTankHeavy);
                break;
            }
            case "medium": {
                tank = ItemStackUtil.itemStack(GCItems.oxTankMedium);
                break;
            }
            case "light": {
                tank = ItemStackUtil.itemStack(GCItems.oxTankLight);
            }
        }
        return tank;
    }

    private static ItemStack setThermals(int meta) {
        String val = GalacticraftModuleConfig.thermalArmor.get();
        ItemStack thermal = null;
        switch (val) {
            case "isothermal": {
                thermal = ItemStackUtil.itemStack(VenusItems.thermalPaddingTier2, meta);
                break;
            }
            case "thermal": {
                thermal = ItemStackUtil.itemStack(AsteroidsItems.thermalPadding, meta);
                break;
            }
        }
        return thermal;
    }

    @Override
    public void ServerStartingEvent(FMLServerStartingEvent event) {
        if (this.isEnabled()) {
            event.registerServerCommand((ICommand)new CommandOxygenReset());
        }
    }

    @Override
    public boolean isEnabled() {
        return GalacticraftModuleConfig.OXYGEN_SPAWN_GEAR;
    }

    public class CommandOxygenReset
    extends CommandBase {
        public String func_71517_b() {
            return "oxygenreset";
        }

        public List<String> func_71514_a() {
            return ImmutableList.of((Object)"oxyreset");
        }

        public String func_71518_a(ICommandSender sender) {
            StringBuilder aliases = new StringBuilder();
            aliases.append(String.join((CharSequence)" | ", this.func_71514_a()));
            return String.format("%sUsage: %s/%s <playername>\n%sAliases: %s%s", TextFormatting.RED, TextFormatting.AQUA, this.func_71517_b(), TextFormatting.RED, TextFormatting.GREEN, aliases.toString());
        }

        public int func_82362_a() {
            return 4;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandOxygenReset.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return null;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 0 && args.length < 2) {
                EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
                if (player != null) {
                    NBTTagCompound entityData = player.getEntityData();
                    NBTTagCompound persistedData = entityData.func_74775_l("PlayerPersisted");
                    entityData.func_74782_a("PlayerPersisted", (NBTBase)persistedData);
                    String key = "galactictweaks:ReceivedOxygen";
                    persistedData.func_74757_a("galactictweaks:ReceivedOxygen", false);
                    String line = String.format("Sucessfully reset %s's OxygenGear-On-Join setting", player.func_70005_c_());
                    sender.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            }
        }
    }
}

