/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.world;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.rom.exoplanets.content.EnumMetal;

public class OverworldOreGen
implements IWorldGenerator {
    public WorldGenerator oreCopper = new WorldGenMinable(EnumMetal.COPPER.getOre(), 4);
    public WorldGenerator oreTin = new WorldGenMinable(EnumMetal.TIN.getOre(), 5);
    public WorldGenerator oreLead = new WorldGenMinable(EnumMetal.LEAD.getOre(), 3);
    public WorldGenerator oreNickel = new WorldGenMinable(EnumMetal.NICKEL.getOre(), 5);
    public WorldGenerator orePlatnium = new WorldGenMinable(EnumMetal.PLATINUM.getOre(), 2);
    public WorldGenerator oreAluminium = new WorldGenMinable(EnumMetal.ALUMINIUM.getOre(), 4);
    public WorldGenerator oreTitanium = new WorldGenMinable(EnumMetal.TITANIUM.getOre(), 2);
    public WorldGenerator oreTungsten = new WorldGenMinable(EnumMetal.ZINC.getOre(), 4);

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_186058_p().func_186068_a()) {
            case 0: {
                this.runGenerator(this.oreCopper, world, random, chunkX, chunkZ, 6, 35, 64);
                this.runGenerator(this.oreTin, world, random, chunkX, chunkZ, 4, 0, 64);
                this.runGenerator(this.oreLead, world, random, chunkX, chunkZ, 5, 0, 64);
                this.runGenerator(this.oreNickel, world, random, chunkX, chunkZ, 5, 0, 64);
                this.runGenerator(this.orePlatnium, world, random, chunkX, chunkZ, 1, 3, 25);
                this.runGenerator(this.oreAluminium, world, random, chunkX, chunkZ, 4, 45, 64);
                this.runGenerator(this.oreTitanium, world, random, chunkX, chunkZ, 2, 35, 75);
                this.runGenerator(this.oreTungsten, world, random, chunkX, chunkZ, 3, 6, 50);
            }
        }
    }
}

