/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@ParametersAreNonnullByDefault
public class StringUtil {
    public static String readFromFile(ResourceLocation location) {
        StringBuilder text = new StringBuilder();
        try {
            String line;
            String path = "/assets/" + location.func_110624_b() + "/" + location.func_110623_a();
            InputStream descriptionStream = StringUtil.class.getResourceAsStream(path);
            if (descriptionStream == null) {
                return text.toString();
            }
            LineNumberReader descriptionReader = new LineNumberReader(new InputStreamReader(descriptionStream));
            while ((line = descriptionReader.readLine()) != null) {
                text.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text.toString();
    }

    public static String addPrefix(String name, String prefix) {
        if (prefix.endsWith("-")) {
            return prefix.substring(0, prefix.length() - 2) + Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return prefix + " " + name;
    }

    public static String addSuffix(String name, String suffix) {
        if (suffix.startsWith("-")) {
            return name + suffix.substring(1);
        }
        return name + " " + suffix;
    }

    public static String[] formatVariations(String unlocalizedName, String unlocalizedSuffix, int count) {
        String[] variations = new String[count];
        for (int i = 0; i < count; ++i) {
            variations[i] = unlocalizedName + "." + i + "." + unlocalizedSuffix;
        }
        return variations;
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSplitString(FontRenderer renderer, String strg, int x, int y, int width, int color, boolean shadow) {
        List list = renderer.func_78271_c(strg, width);
        for (int i = 0; i < list.size(); ++i) {
            String s1 = (String)list.get(i);
            renderer.func_175065_a(s1, (float)x, (float)(y + i * renderer.field_78288_b), color, shadow);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderScaledAsciiString(FontRenderer font, String text, int x, int y, int color, boolean shadow, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        boolean oldUnicode = font.func_82883_a();
        font.func_78264_a(false);
        font.func_175065_a(text, (float)x / scale, (float)y / scale, color, shadow);
        font.func_78264_a(oldUnicode);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderSplitScaledAsciiString(FontRenderer font, String text, int x, int y, int color, boolean shadow, float scale, int length) {
        List lines = font.func_78271_c(text, (int)((float)length / scale));
        for (int i = 0; i < lines.size(); ++i) {
            StringUtil.renderScaledAsciiString(font, (String)lines.get(i), x, y + i * (int)((float)font.field_78288_b * scale + 3.0f), color, shadow, scale);
        }
    }
}

