/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.StringUtils;

public class ReflectionHelper {
    public static Field getDeclaredField(Class<?> c, String fieldname) {
        try {
            Field f = c.getDeclaredField(fieldname);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getPrivateMethod(Class<?> c, String methodName) {
        try {
            Method m = c.getDeclaredMethod(methodName, c);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean setField(Field f, Object instance, Object value) {
        try {
            f.set(instance, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Object setStaticFinalField(Field f, Class<?> c, Object value) {
        Object o = null;
        try {
            f.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            o = f.get(c);
            f.set(null, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    @Nonnull
    public static Field findField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String fieldObfName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        String nameToFind = FMLLaunchHandler.isDeobfuscatedEnvironment() ? fieldName : (String)MoreObjects.firstNonNull((Object)fieldObfName, (Object)fieldName);
        try {
            Field f = clazz.getDeclaredField(nameToFind);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }
}

