/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.util;

import com.google.common.primitives.UnsignedInts;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;

public class RGB {
    private static final Map<String, RGB> NAMED_MAP = new HashMap<String, RGB>();
    private static final Pattern PATTERN_LEADING_JUNK = Pattern.compile("(#|0x)", 2);
    private static final Pattern PATTERN_HEX_CODE = Pattern.compile("(#|0x)?[0-9a-f]{1,8}", 2);
    public static final int VALUE_WHITE = 0xFFFFFF;
    public static final RGB ALICEBLUE = RGB.named("AliceBlue", 0xF0F8FF);
    public static final RGB ANTIQUEWHITE = RGB.named("AntiqueWhite", 16444375);
    public static final RGB AQUA = RGB.named("Aqua", 65535);
    public static final RGB AQUAMARINE = RGB.named("Aquamarine", 8388564);
    public static final RGB AZURE = RGB.named("Azure", 0xF0FFFF);
    public static final RGB BEIGE = RGB.named("Beige", 16119260);
    public static final RGB BISQUE = RGB.named("Bisque", 16770244);
    public static final RGB BLACK = RGB.named("Black", 0);
    public static final RGB BLANCHEDALMOND = RGB.named("BlanchedAlmond", 16772045);
    public static final RGB BLUE = RGB.named("Blue", 255);
    public static final RGB BLUEVIOLET = RGB.named("BlueViolet", 9055202);
    public static final RGB BROWN = RGB.named("Brown", 0xA52A2A);
    public static final RGB BURLYWOOD = RGB.named("BurlyWood", 14596231);
    public static final RGB CADETBLUE = RGB.named("CadetBlue", 6266528);
    public static final RGB CHARTREUSE = RGB.named("Chartreuse", 0x7FFF00);
    public static final RGB CHOCOLATE = RGB.named("Chocolate", 13789470);
    public static final RGB CORAL = RGB.named("Coral", 16744272);
    public static final RGB CORNFLOWERBLUE = RGB.named("CornflowerBlue", 6591981);
    public static final RGB CORNSILK = RGB.named("Cornsilk", 16775388);
    public static final RGB CRIMSON = RGB.named("Crimson", 14423100);
    public static final RGB CYAN = RGB.named("Cyan", 65535);
    public static final RGB DARKBLUE = RGB.named("DarkBlue", 139);
    public static final RGB DARKCYAN = RGB.named("DarkCyan", 35723);
    public static final RGB DARKGOLDENROD = RGB.named("DarkGoldenRod", 12092939);
    public static final RGB DARKGRAY = RGB.named("DarkGray", 0xA9A9A9);
    public static final RGB DARKGREY = RGB.named("DarkGrey", 0xA9A9A9);
    public static final RGB DARKGREEN = RGB.named("DarkGreen", 25600);
    public static final RGB DARKKHAKI = RGB.named("DarkKhaki", 12433259);
    public static final RGB DARKMAGENTA = RGB.named("DarkMagenta", 0x8B008B);
    public static final RGB DARKOLIVEGREEN = RGB.named("DarkOliveGreen", 5597999);
    public static final RGB DARKORANGE = RGB.named("DarkOrange", 16747520);
    public static final RGB DARKORCHID = RGB.named("DarkOrchid", 10040012);
    public static final RGB DARKRED = RGB.named("DarkRed", 0x8B0000);
    public static final RGB DARKSALMON = RGB.named("DarkSalmon", 15308410);
    public static final RGB DARKSEAGREEN = RGB.named("DarkSeaGreen", 9419919);
    public static final RGB DARKSLATEBLUE = RGB.named("DarkSlateBlue", 4734347);
    public static final RGB DARKSLATEGRAY = RGB.named("DarkSlateGray", 0x2F4F4F);
    public static final RGB DARKSLATEGREY = RGB.named("DarkSlateGrey", 0x2F4F4F);
    public static final RGB DARKTURQUOISE = RGB.named("DarkTurquoise", 52945);
    public static final RGB DARKVIOLET = RGB.named("DarkViolet", 9699539);
    public static final RGB DEEPPINK = RGB.named("DeepPink", 16716947);
    public static final RGB DEEPSKYBLUE = RGB.named("DeepSkyBlue", 49151);
    public static final RGB DIMGRAY = RGB.named("DimGray", 0x696969);
    public static final RGB DIMGREY = RGB.named("DimGrey", 0x696969);
    public static final RGB DODGERBLUE = RGB.named("DodgerBlue", 2003199);
    public static final RGB FIREBRICK = RGB.named("FireBrick", 0xB22222);
    public static final RGB FLORALWHITE = RGB.named("FloralWhite", 0xFFFAF0);
    public static final RGB FORESTGREEN = RGB.named("ForestGreen", 0x228B22);
    public static final RGB FUCHSIA = RGB.named("Fuchsia", 0xFF00FF);
    public static final RGB GAINSBORO = RGB.named("Gainsboro", 0xDCDCDC);
    public static final RGB GHOSTWHITE = RGB.named("GhostWhite", 0xF8F8FF);
    public static final RGB GOLD = RGB.named("Gold", 16766720);
    public static final RGB GOLDENROD = RGB.named("GoldenRod", 14329120);
    public static final RGB GRAY = RGB.named("Gray", 0x808080);
    public static final RGB GREY = RGB.named("Grey", 0x808080);
    public static final RGB GREEN = RGB.named("Green", 32768);
    public static final RGB GREENYELLOW = RGB.named("GreenYellow", 11403055);
    public static final RGB HONEYDEW = RGB.named("HoneyDew", 0xF0FFF0);
    public static final RGB HOTPINK = RGB.named("HotPink", 16738740);
    public static final RGB INDIANRED = RGB.named("IndianRed", 0xCD5C5C);
    public static final RGB INDIGO = RGB.named("Indigo", 4915330);
    public static final RGB IVORY = RGB.named("Ivory", 0xFFFFF0);
    public static final RGB KHAKI = RGB.named("Khaki", 15787660);
    public static final RGB LAVENDER = RGB.named("Lavender", 15132410);
    public static final RGB LAVENDERBLUSH = RGB.named("LavenderBlush", 0xFFF0F5);
    public static final RGB LAWNGREEN = RGB.named("LawnGreen", 8190976);
    public static final RGB LEMONCHIFFON = RGB.named("LemonChiffon", 16775885);
    public static final RGB LIGHTBLUE = RGB.named("LightBlue", 11393254);
    public static final RGB LIGHTCORAL = RGB.named("LightCoral", 0xF08080);
    public static final RGB LIGHTCYAN = RGB.named("LightCyan", 0xE0FFFF);
    public static final RGB LIGHTGOLDENRODYELLOW = RGB.named("LightGoldenRodYellow", 16448210);
    public static final RGB LIGHTGRAY = RGB.named("LightGray", 0xD3D3D3);
    public static final RGB LIGHTGREY = RGB.named("LightGrey", 0xD3D3D3);
    public static final RGB LIGHTGREEN = RGB.named("LightGreen", 0x90EE90);
    public static final RGB LIGHTPINK = RGB.named("LightPink", 16758465);
    public static final RGB LIGHTSALMON = RGB.named("LightSalmon", 16752762);
    public static final RGB LIGHTSEAGREEN = RGB.named("LightSeaGreen", 2142890);
    public static final RGB LIGHTSKYBLUE = RGB.named("LightSkyBlue", 8900346);
    public static final RGB LIGHTSLATEGRAY = RGB.named("LightSlateGray", 0x778899);
    public static final RGB LIGHTSLATEGREY = RGB.named("LightSlateGrey", 0x778899);
    public static final RGB LIGHTSTEELBLUE = RGB.named("LightSteelBlue", 11584734);
    public static final RGB LIGHTYELLOW = RGB.named("LightYellow", 0xFFFFE0);
    public static final RGB LIME = RGB.named("Lime", 65280);
    public static final RGB LIMEGREEN = RGB.named("LimeGreen", 3329330);
    public static final RGB LINEN = RGB.named("Linen", 16445670);
    public static final RGB MAGENTA = RGB.named("Magenta", 0xFF00FF);
    public static final RGB MAROON = RGB.named("Maroon", 0x800000);
    public static final RGB MEDIUMAQUAMARINE = RGB.named("MediumAquaMarine", 6737322);
    public static final RGB MEDIUMBLUE = RGB.named("MediumBlue", 205);
    public static final RGB MEDIUMORCHID = RGB.named("MediumOrchid", 12211667);
    public static final RGB MEDIUMPURPLE = RGB.named("MediumPurple", 9662683);
    public static final RGB MEDIUMSEAGREEN = RGB.named("MediumSeaGreen", 3978097);
    public static final RGB MEDIUMSLATEBLUE = RGB.named("MediumSlateBlue", 8087790);
    public static final RGB MEDIUMSPRINGGREEN = RGB.named("MediumSpringGreen", 64154);
    public static final RGB MEDIUMTURQUOISE = RGB.named("MediumTurquoise", 4772300);
    public static final RGB MEDIUMVIOLETRED = RGB.named("MediumVioletRed", 13047173);
    public static final RGB MIDNIGHTBLUE = RGB.named("MidnightBlue", 1644912);
    public static final RGB MINTCREAM = RGB.named("MintCream", 0xF5FFFA);
    public static final RGB MISTYROSE = RGB.named("MistyRose", 16770273);
    public static final RGB MOCCASIN = RGB.named("Moccasin", 16770229);
    public static final RGB NAVAJOWHITE = RGB.named("NavajoWhite", 16768685);
    public static final RGB NAVY = RGB.named("Navy", 128);
    public static final RGB OLDLACE = RGB.named("OldLace", 16643558);
    public static final RGB OLIVE = RGB.named("Olive", 0x808000);
    public static final RGB OLIVEDRAB = RGB.named("OliveDrab", 7048739);
    public static final RGB ORANGE = RGB.named("Orange", 16753920);
    public static final RGB ORANGERED = RGB.named("OrangeRed", 16729344);
    public static final RGB ORCHID = RGB.named("Orchid", 14315734);
    public static final RGB PALEGOLDENROD = RGB.named("PaleGoldenRod", 0xEEE8AA);
    public static final RGB PALEGREEN = RGB.named("PaleGreen", 10025880);
    public static final RGB PALETURQUOISE = RGB.named("PaleTurquoise", 0xAFEEEE);
    public static final RGB PALEVIOLETRED = RGB.named("PaleVioletRed", 14381203);
    public static final RGB PAPAYAWHIP = RGB.named("PapayaWhip", 16773077);
    public static final RGB PEACHPUFF = RGB.named("PeachPuff", 16767673);
    public static final RGB PERU = RGB.named("Peru", 13468991);
    public static final RGB PINK = RGB.named("Pink", 16761035);
    public static final RGB PLUM = RGB.named("Plum", 0xDDA0DD);
    public static final RGB POWDERBLUE = RGB.named("PowderBlue", 11591910);
    public static final RGB PURPLE = RGB.named("Purple", 0x800080);
    public static final RGB REBECCAPURPLE = RGB.named("RebeccaPurple", 0x663399);
    public static final RGB RED = RGB.named("Red", 0xFF0000);
    public static final RGB ROSYBROWN = RGB.named("RosyBrown", 12357519);
    public static final RGB ROYALBLUE = RGB.named("RoyalBlue", 4286945);
    public static final RGB SADDLEBROWN = RGB.named("SaddleBrown", 9127187);
    public static final RGB SALMON = RGB.named("Salmon", 16416882);
    public static final RGB SANDYBROWN = RGB.named("SandyBrown", 16032864);
    public static final RGB SEAGREEN = RGB.named("SeaGreen", 3050327);
    public static final RGB SEASHELL = RGB.named("SeaShell", 0xFFF5EE);
    public static final RGB SIENNA = RGB.named("Sienna", 10506797);
    public static final RGB SILVER = RGB.named("Silver", 0xC0C0C0);
    public static final RGB SKYBLUE = RGB.named("SkyBlue", 8900331);
    public static final RGB SLATEBLUE = RGB.named("SlateBlue", 6970061);
    public static final RGB SLATEGRAY = RGB.named("SlateGray", 7372944);
    public static final RGB SLATEGREY = RGB.named("SlateGrey", 7372944);
    public static final RGB SNOW = RGB.named("Snow", 0xFFFAFA);
    public static final RGB SPRINGGREEN = RGB.named("SpringGreen", 65407);
    public static final RGB STEELBLUE = RGB.named("SteelBlue", 4620980);
    public static final RGB TAN = RGB.named("Tan", 13808780);
    public static final RGB TEAL = RGB.named("Teal", 32896);
    public static final RGB THISTLE = RGB.named("Thistle", 14204888);
    public static final RGB TOMATO = RGB.named("Tomato", 16737095);
    public static final RGB TURQUOISE = RGB.named("Turquoise", 4251856);
    public static final RGB VIOLET = RGB.named("Violet", 0xEE82EE);
    public static final RGB WHEAT = RGB.named("Wheat", 16113331);
    public static final RGB WHITE = RGB.named("White", 0xFFFFFF);
    public static final RGB WHITESMOKE = RGB.named("WhiteSmoke", 0xF5F5F5);
    public static final RGB YELLOW = RGB.named("Yellow", 0xFFFF00);
    public static final RGB YELLOWGREEN = RGB.named("YellowGreen", 10145074);
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;

    public RGB(int color) {
        this(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public RGB(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
    }

    public RGB(int red, int green, int blue, int alpha) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public RGB(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public RGB(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    private static RGB named(String name, int color) {
        RGB c = new RGB(color);
        NAMED_MAP.put(name.toLowerCase(Locale.ROOT), c);
        return c;
    }

    public static boolean validate(String str) {
        return NAMED_MAP.containsKey(str.toLowerCase(Locale.ROOT)) || PATTERN_HEX_CODE.matcher(str).matches();
    }

    public static String format(int color) {
        return String.format(color > 0xFFFFFF ? "#%08X" : "#%06X", color);
    }

    public static RGB parse(String str) {
        if (NAMED_MAP.containsKey(str = str.toLowerCase(Locale.ROOT))) {
            return NAMED_MAP.get(str);
        }
        str = PATTERN_LEADING_JUNK.matcher(str).replaceFirst("");
        int color = UnsignedInts.parseUnsignedInt((String)str, (int)16);
        return new RGB(color);
    }

    public static RGB tryParse(String str, int defaultValue) {
        if (!RGB.validate(str)) {
            return new RGB(defaultValue);
        }
        return RGB.parse(str);
    }

    public static RGB from(JsonObject json, String propertyName, int defaultValue) {
        String defaultStr = Integer.toHexString(defaultValue);
        return RGB.parse(JsonUtils.func_151219_a((JsonObject)json, (String)propertyName, (String)defaultStr));
    }

    public RGB blendWith(RGB other) {
        return RGB.blend(this, other);
    }

    public static RGB blend(RGB color1, RGB color2) {
        return RGB.blend(color1, color2, 0.5f);
    }

    public static RGB blend(RGB color1, RGB color2, float ratio) {
        int i1 = color1.getColor();
        int i2 = color2.getColor();
        int color = RGB.blend(i1, i2, ratio);
        return new RGB(color);
    }

    public static int blend(int color1, int color2) {
        return RGB.blend(color1, color2, 0.5f);
    }

    public static int blend(int color1, int color2, float ratio) {
        ratio = MathHelper.func_76131_a((float)ratio, (float)0.0f, (float)1.0f);
        float iRatio = 1.0f - ratio;
        int a1 = color1 >> 24 & 0xFF;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public int getColor() {
        int r = (int)(this.red * 255.0f) << 16;
        int g = (int)(this.green * 255.0f) << 8;
        int b = (int)(this.blue * 255.0f);
        return r + g + b;
    }

    public int getColorWithA() {
        int a = (int)(this.alpha * 255.0f) << 24;
        int r = (int)(this.red * 255.0f) << 16;
        int g = (int)(this.green * 255.0f) << 8;
        int b = (int)(this.blue * 255.0f);
        return a + r + g + b;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRedInt() {
        return (int)(this.red * 255.0f);
    }

    public int getGreenInt() {
        return (int)(this.green * 255.0f);
    }

    public int getBlueInt() {
        return (int)(this.blue * 255.0f);
    }

    public int getAlphaInt() {
        return (int)(this.alpha * 255.0f);
    }
}

