/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research.utils;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.api.research.IResearch;
import net.rom.api.research.ResearchStack;

public class ResearchFactory {
    public static final String COMPLETED = "\u25a0";
    public static final String UNCOMPLETE = "\u25a1";

    public ResearchStack generateResearchStack(Random random, IResearch research) {
        ResearchStack researchStack = new ResearchStack(research);
        research.initResearchStack(random, researchStack);
        return researchStack;
    }

    @SideOnly(value=Side.CLIENT)
    public String getFormattedResearchObjective(EntityPlayer entityPlayer, ResearchStack researchStack, int objectiveInex) {
        boolean isCompleted = researchStack.isObjectiveCompleted(entityPlayer, objectiveInex);
        if (isCompleted) {
            return TextFormatting.GREEN + COMPLETED + " " + researchStack.getObjective(entityPlayer, objectiveInex);
        }
        return TextFormatting.DARK_GREEN + UNCOMPLETE + " " + researchStack.getObjective(entityPlayer, objectiveInex);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getFormattedResearchObjective(EntityPlayer entityPlayer, ResearchStack researchStack, int objectiveInex, int length) {
        return this.getFormattedResearchObjective(entityPlayer, researchStack, objectiveInex, length, TextFormatting.DARK_GREEN.toString(), TextFormatting.GREEN.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getFormattedResearchObjective(EntityPlayer entityPlayer, ResearchStack researchStack, int objectiveInex, int length, String uncompletedPrefix, String completedPrefix) {
        List objectiveLines = Minecraft.func_71410_x().field_71466_p.func_78271_c(researchStack.getObjective(entityPlayer, objectiveInex), length);
        boolean isObjectiveComplete = researchStack.isObjectiveCompleted((EntityPlayer)Minecraft.func_71410_x().field_71439_g, objectiveInex);
        for (int o = 0; o < objectiveLines.size(); ++o) {
            String line = "";
            if (isObjectiveComplete) {
                line = line + completedPrefix;
                if (o == 0) {
                    line = line + "\u25a0 ";
                }
            } else {
                line = line + uncompletedPrefix;
                if (o == 0) {
                    line = line + "\u25a1 ";
                }
            }
            line = line + (String)objectiveLines.get(o);
            objectiveLines.set(o, line);
        }
        return objectiveLines;
    }
}

