/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.rom.api.research.conversation.IConversationNpc;
import net.rom.api.research.conversation.IConversationRegistry;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.research.conversation.ConversationMessage;

public class ConversationFactory {
    private final IConversationRegistry registry;

    public ConversationFactory(IConversationRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationMessage[] constructMultipleLineConversation(Class<? extends ConversationMessage> mainMessageType, String unlocalizedName, int lines, String nextLineResearchion) {
        ConversationMessage[] messages = new ConversationMessage[lines];
        try {
            messages[0] = mainMessageType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            messages[0] = new ConversationMessage();
        }
        finally {
            this.registry.registerMessage(messages[0]);
        }
        messages[0].setMessages(new String[]{String.format("%s.%s.line", unlocalizedName, 0)});
        messages[0].setResearchions(new String[]{unlocalizedName + ".researchion"});
        messages[0].setUnlocalized(true);
        ConversationMessage lastChild = messages[0];
        for (int i = 1; i < lines; ++i) {
            ConversationMessage child = new ConversationMessage("", nextLineResearchion);
            this.registry.registerMessage(child);
            child.setMessages(new String[]{String.format("%s.%s.line", unlocalizedName, i)});
            if (ExoplanetsMod.translate.hasKey(String.format("%s.%s.researchion", unlocalizedName, i))) {
                child.setResearchions(new String[]{String.format("%s.%s.researchion", unlocalizedName, i)});
            }
            child.setUnlocalized(true);
            child.setParent(lastChild);
            lastChild.addOption(child);
            lastChild = child;
            messages[i] = child;
        }
        return messages;
    }

    public ConversationMessage addOnlyVisibleOptions(EntityPlayer entityPlayer, IConversationNpc ConversationNpc, ConversationMessage parent, ConversationMessage ... options) {
        for (ConversationMessage option : options) {
            if (!option.isVisible(ConversationNpc, entityPlayer)) continue;
            parent.addOption(option);
        }
        return parent;
    }
}

