/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research.conversation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.api.research.conversation.IConversationMessage;
import net.rom.api.research.conversation.IConversationMessageSeedable;
import net.rom.api.research.conversation.IConversationNpc;
import net.rom.api.research.conversation.IConversationOption;
import net.rom.api.research.exception.ExoRuntimeException;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.research.utils.JsonUtil;

public class ConversationMessage
implements IConversationMessage,
IConversationMessageSeedable {
    protected static Random random = new Random();
    protected String[] messages;
    protected String[] researchions;
    protected boolean unlocalized;
    protected IConversationMessage parent;
    protected List<IConversationOption> options;
    @SideOnly(value=Side.CLIENT)
    protected String holoIcon;
    protected long seed;

    public ConversationMessage(JsonObject object) {
        this.init();
        this.unlocalized = JsonUtil.getBool(object, "unlocalized", false);
        if (object.has("message")) {
            JsonElement messageElement = object.get("message");
            if (messageElement.isJsonArray()) {
                this.messages = JsonUtil.getStringArray(object, "message");
            } else if (messageElement.isJsonPrimitive() && messageElement.getAsJsonPrimitive().isString()) {
                this.messages = new String[]{messageElement.getAsString()};
            }
        } else {
            throw new ExoRuntimeException(String.format("Cannot find Message for Conversation", new Object[0]));
        }
        if (object.has("researchion")) {
            JsonElement researchionElement = object.get("researchion");
            if (researchionElement.isJsonArray()) {
                this.researchions = JsonUtil.getStringArray(object, "message");
            } else if (researchionElement.isJsonPrimitive() && researchionElement.getAsJsonPrimitive().isString()) {
                this.researchions = new String[]{researchionElement.getAsString()};
            }
        }
    }

    public ConversationMessage() {
        this.init();
    }

    public ConversationMessage(String message) {
        this(message, message);
    }

    public ConversationMessage(String message, String researchion) {
        String[] stringArray;
        String[] stringArray2;
        if (message != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = message;
        } else {
            stringArray2 = null;
        }
        if (researchion != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = researchion;
        } else {
            stringArray = null;
        }
        this(stringArray2, stringArray);
    }

    public ConversationMessage(String[] messages, String[] researchions) {
        this.messages = messages;
        this.researchions = researchions;
        this.init();
    }

    private void init() {
        this.options = new ArrayList<IConversationOption>();
    }

    @Override
    public IConversationMessage getParent(IConversationNpc npc, EntityPlayer player) {
        return this.parent;
    }

    @Override
    public List<IConversationOption> getOptions(IConversationNpc npc, EntityPlayer player) {
        return this.options;
    }

    @Override
    public String getMessageText(IConversationNpc npc, EntityPlayer player) {
        if (this.messages != null && this.messages.length > 0) {
            int messageIndex = 0;
            if (this.messages.length > 1) {
                messageIndex = random.nextInt(this.messages.length);
            }
            return this.formatMessage(this.messages[messageIndex], npc, player);
        }
        return "";
    }

    @Override
    public String getResearchionText(IConversationNpc npc, EntityPlayer player) {
        if (this.researchions != null && this.researchions.length > 0) {
            int researchionIndex = 0;
            if (this.researchions.length > 1) {
                researchionIndex = random.nextInt(this.researchions.length);
            }
            return this.formatResearchion(this.researchions[researchionIndex], npc, player);
        }
        return "";
    }

    @Override
    public void onOptionsInteract(IConversationNpc npc, EntityPlayer player, int option) {
        if (option >= 0 && option < this.options.size()) {
            this.options.get(option).onInteract(npc, player);
        }
    }

    @Override
    public void onInteract(IConversationNpc npc, EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    protected void setAsGuiActiveMessage(IConversationNpc npc, EntityPlayer player) {
    }

    @Override
    public boolean canInteract(IConversationNpc npc, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isVisible(IConversationNpc npc, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHoloIcon(IConversationNpc npc, EntityPlayer player) {
        return this.holoIcon;
    }

    @Override
    public boolean equalsOption(IConversationOption other) {
        return this.equals(other);
    }

    public void setParent(IConversationMessage parent) {
        this.parent = parent;
    }

    public void addOption(IConversationOption message) {
        this.options.add(message);
    }

    public IConversationOption getOption(int id) {
        return this.options.get(id);
    }

    public List<IConversationOption> getOptions() {
        return this.options;
    }

    @SideOnly(value=Side.CLIENT)
    public ConversationMessage setHoloIcon(String holoIcon) {
        this.holoIcon = holoIcon;
        return this;
    }

    protected String formatMessage(String text, IConversationNpc npc, EntityPlayer player) {
        if (text != null) {
            return String.format(this.unlocalized ? ExoplanetsMod.translate.translate(text, new Object[0]) : text, player.func_145748_c_().func_150254_d(), npc.getEntity().func_145748_c_().func_150254_d());
        }
        return null;
    }

    protected String formatResearchion(String text, IConversationNpc npc, EntityPlayer player) {
        if (text != null) {
            return String.format(this.unlocalized ? ExoplanetsMod.translate.translate(text, new Object[0]) : text, player.func_145748_c_().func_150254_d(), npc.getEntity().func_145748_c_().func_150254_d());
        }
        return null;
    }

    public ConversationMessage setUnlocalized(boolean unlocalized) {
        this.unlocalized = unlocalized;
        return this;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        random.setSeed(seed);
    }

    public void setResearchions(String[] researchions) {
        this.researchions = researchions;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }
}

