/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research;

import com.google.gson.JsonObject;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.rom.exoplanets.research.utils.JsonUtil;

public class ResearchItem {
    ItemStack itemStack;
    int itemAmount;
    int itemDamage;
    String name;
    String mod;
    NBTTagCompound nbtTagCompound;
    boolean ignoreDamage;
    boolean ignoreNBT;

    public ResearchItem(JsonObject object) {
        this.name = JsonUtil.getString(object, "id");
        this.itemAmount = JsonUtil.getInt(object, "count", 1);
        this.itemDamage = JsonUtil.getInt(object, "damage", 0);
        this.mod = JsonUtil.getString(object, "mod", null);
        this.nbtTagCompound = JsonUtil.getNbt(object, "nbt", null);
        this.ignoreDamage = JsonUtil.getBool(object, "ignore_damage", false);
        this.ignoreNBT = JsonUtil.getBool(object, "ignore_nbt", false);
    }

    public ResearchItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ResearchItem(String name, String mod) {
        this(name, mod, 1, 0, null);
    }

    public ResearchItem(String name, String mod, int itemAmount) {
        this(name, mod, itemAmount, 0, null);
    }

    public ResearchItem(String name, String mod, int itemAmount, int itemDamage) {
        this(name, mod, itemAmount, itemDamage, null);
    }

    public ResearchItem(String name, String mod, int itemAmount, int itemDamage, NBTTagCompound tagCompound) {
        this.name = name;
        this.mod = mod;
        this.itemAmount = itemAmount;
        this.itemDamage = itemDamage;
        this.nbtTagCompound = tagCompound;
    }

    public static ResearchItem fromItemStack(ItemStack itemStack) {
        return new ResearchItem(itemStack);
    }

    public boolean isModded() {
        return this.mod != null && !this.mod.isEmpty();
    }

    public boolean isModPresent() {
        return Loader.isModLoaded((String)this.mod);
    }

    public boolean canItemExist() {
        if (this.isModded()) {
            return this.isModPresent();
        }
        return true;
    }

    public ItemStack getItemStack() {
        if (this.isModded() || this.itemStack == null) {
            Item item = Item.func_111206_d((String)this.name);
            if (item != null) {
                ItemStack itemStack = new ItemStack(item, this.itemAmount, this.itemDamage);
                itemStack.func_77982_d(this.nbtTagCompound);
                return itemStack;
            }
        } else {
            return this.itemStack;
        }
        return null;
    }

    public boolean matches(ItemStack itemStack) {
        if (this.itemStack != null) {
            return !(!itemStack.func_77973_b().equals(this.itemStack.func_77973_b()) || !this.ignoreDamage && itemStack.func_77952_i() != this.itemStack.func_77952_i() || !this.ignoreNBT && !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)this.itemStack));
        }
        return !(!itemStack.func_77973_b().getRegistryName().toString().equals(this.name) || !this.ignoreDamage && this.itemDamage != itemStack.func_77952_i() || !this.ignoreNBT && this.nbtTagCompound != null && !this.nbtTagCompound.equals((Object)itemStack.func_77978_p()));
    }
}

