/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research;

import com.google.gson.JsonObject;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.common.Loader;
import net.rom.exoplanets.research.utils.JsonUtil;

public class ResearchBlock {
    IBlockState block;
    String blockName;
    int blockMeta;
    boolean hasMeta;
    String mod;

    public ResearchBlock(JsonObject object) {
        if (object.has("meta")) {
            this.setBlockMeta(JsonUtil.getInt(object, "meta"));
        }
        this.blockName = JsonUtil.getString(object, "id");
        this.mod = JsonUtil.getString(object, "mod", null);
    }

    public ResearchBlock(IBlockState block) {
        this.block = block;
    }

    public ResearchBlock(String blockName, String mod) {
        this.blockName = blockName;
        this.mod = mod;
    }

    public static ResearchBlock fromBlock(IBlockState block) {
        return new ResearchBlock(block);
    }

    public boolean isModded() {
        return this.mod != null && !this.mod.isEmpty();
    }

    public boolean isModPresent() {
        return Loader.isModLoaded((String)this.mod);
    }

    public boolean canBlockExist() {
        if (this.isModded()) {
            return this.isModPresent();
        }
        return true;
    }

    public IBlockState getBlockState() {
        if (this.isModded() || this.block == null) {
            if (this.hasMeta) {
                return Block.func_149684_b((String)this.blockName).func_176203_a(this.blockMeta);
            }
            return Block.func_149684_b((String)this.blockName).func_176223_P();
        }
        return this.block;
    }

    public boolean isTheSame(IBlockState blockState) {
        if (this.hasMeta) {
            return this.getBlockState().equals(blockState);
        }
        return this.getBlockState().func_177230_c().equals(blockState.func_177230_c());
    }

    public void setBlockMeta(int meta) {
        this.blockMeta = meta;
        this.hasMeta = true;
    }
}

