/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.rom.api.research.IResearchLogic;
import net.rom.api.research.ResearchStack;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.research.GenericResearch;

public class RandomResearchText
extends GenericResearch {
    int variationsCount;

    public RandomResearchText(IResearchLogic researchLogic, String title, int variationsCount, int xpReward) {
        super(researchLogic, title, xpReward);
        this.variationsCount = variationsCount;
    }

    @Override
    public void initResearchStack(Random random, ResearchStack researchStack, EntityPlayer entityPlayer) {
        super.initResearchStack(random, researchStack, entityPlayer);
        NBTTagCompound data = researchStack.getTagCompound();
        if (data == null) {
            data = new NBTTagCompound();
            researchStack.setTagCompound(data);
        }
        data.func_74777_a("Variation", (short)random.nextInt(this.variationsCount));
    }

    @Override
    public boolean areResearchStacksEqual(ResearchStack researchStackOne, ResearchStack researchStackTwo) {
        if (researchStackOne == null && researchStackTwo == null) {
            return true;
        }
        if (researchStackOne.getTagCompound() == null && researchStackTwo.getTagCompound() == null) {
            return super.areResearchStacksEqual(researchStackOne, researchStackTwo);
        }
        if (researchStackOne.getTagCompound() != null && researchStackTwo.getTagCompound() != null) {
            return super.areResearchStacksEqual(researchStackOne, researchStackTwo) && researchStackOne.getTagCompound().func_74765_d("Variation") == researchStackTwo.getTagCompound().func_74765_d("Variation");
        }
        return false;
    }

    public int getVariation(ResearchStack researchStack) {
        if (researchStack.getTagCompound() != null) {
            return researchStack.getTagCompound().func_74765_d("Variation");
        }
        return 0;
    }

    @Override
    public String getTitle(ResearchStack researchStack) {
        return this.researchLogic.modifyTitle(researchStack, ExoplanetsMod.translate.translate("research." + this.title + "." + this.getVariation(researchStack) + ".title", new Object[0]));
    }

    @Override
    public String getTitle(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.researchLogic.modifyTitle(researchStack, this.replaceVariables(ExoplanetsMod.translate.translate("research." + this.title + "." + this.getVariation(researchStack) + ".title", new Object[0]), entityPlayer));
    }

    @Override
    public String getInfo(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.researchLogic.modifyInfo(researchStack, this.replaceVariables(ExoplanetsMod.translate.translate("research." + this.title + "." + this.getVariation(researchStack) + ".info", new Object[0]), entityPlayer));
    }

    @Override
    public String getObjective(ResearchStack researchStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.researchLogic.modifyObjective(researchStack, entityPlayer, this.replaceVariables(ExoplanetsMod.translate.translate("research." + this.title + "." + this.getVariation(researchStack) + ".objective." + objectiveIndex, new Object[0]), entityPlayer), objectiveIndex);
    }
}

