/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.rom.api.research.ResearchStack;
import net.rom.api.research.ResearchState;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.capability.ResearchCapability;

public class PlayerResearchData {
    final List<ResearchStack> activeResearch = new ArrayList<ResearchStack>();
    final List<ResearchStack> completedResearch = new ArrayList<ResearchStack>();
    final ResearchCapability researchCapability;

    public PlayerResearchData(ResearchCapability extendedProperties) {
        this.researchCapability = extendedProperties;
    }

    public void writeToNBT(NBTTagCompound tagCompound, EnumSet<DataType> dataTypes) {
        NBTTagCompound researchStackNBT;
        NBTTagList activeResearchTagList;
        if (dataTypes.contains((Object)DataType.COMPLETED_RESEARCH) && this.completedResearch.size() > 0) {
            activeResearchTagList = new NBTTagList();
            for (ResearchStack researchStack : this.completedResearch) {
                researchStackNBT = new NBTTagCompound();
                researchStack.writeToNBT(researchStackNBT);
                activeResearchTagList.func_74742_a((NBTBase)researchStackNBT);
            }
            tagCompound.func_74782_a("CompletedResearch", (NBTBase)activeResearchTagList);
        }
        if (dataTypes.contains((Object)DataType.ACTIVE_RESEARCH) && this.activeResearch.size() > 0) {
            activeResearchTagList = new NBTTagList();
            for (ResearchStack researchStack : this.activeResearch) {
                researchStackNBT = new NBTTagCompound();
                researchStack.writeToNBT(researchStackNBT);
                activeResearchTagList.func_74742_a((NBTBase)researchStackNBT);
            }
            tagCompound.func_74782_a("ActiveResearch", (NBTBase)activeResearchTagList);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound, EnumSet<DataType> dataTypes) {
        int i;
        NBTTagList activeResearchTagList;
        if (dataTypes.contains((Object)DataType.COMPLETED_RESEARCH)) {
            this.completedResearch.clear();
            try {
                if (tagCompound.func_150297_b("CompletedResearch", 9)) {
                    activeResearchTagList = tagCompound.func_150295_c("CompletedResearch", 10);
                    for (i = 0; i < activeResearchTagList.func_74745_c(); ++i) {
                        this.completedResearch.add(ResearchStack.loadFromNBT(activeResearchTagList.func_150305_b(i)));
                    }
                }
            }
            catch (Exception e) {
                ExoplanetsMod.logger.error("There was a problem while loading Completed Research", e);
            }
        }
        if (dataTypes.contains((Object)DataType.ACTIVE_RESEARCH)) {
            this.activeResearch.clear();
            try {
                if (tagCompound.func_150297_b("ActiveResearch", 9)) {
                    activeResearchTagList = tagCompound.func_150295_c("ActiveResearch", 10);
                    for (i = 0; i < activeResearchTagList.func_74745_c(); ++i) {
                        this.activeResearch.add(ResearchStack.loadFromNBT(activeResearchTagList.func_150305_b(i)));
                    }
                }
            }
            catch (Exception e) {
                ExoplanetsMod.logger.error("There was a problem while loading Active Research", e);
            }
        }
    }

    public void manageResearchCompletion() {
        int i = 0;
        while (i < this.activeResearch.size()) {
            if (this.activeResearch.get(i).isCompleted()) {
                ResearchStack researchStack = this.activeResearch.remove(i);
                this.researchCapability.onResearchCompleted(researchStack, i);
                continue;
            }
            ++i;
        }
    }

    public boolean hasCompletedResearch(ResearchStack research) {
        for (ResearchStack q : this.completedResearch) {
            if (!q.getResearch().areResearchStacksEqual(q, research)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResearch(ResearchStack researchStack) {
        for (ResearchStack q : this.activeResearch) {
            if (!q.getResearch().areResearchStacksEqual(q, researchStack)) continue;
            return true;
        }
        return false;
    }

    public ResearchStack addResearch(ResearchStack researchStack) {
        if (researchStack.getResearch() != null && this.activeResearch.add(researchStack)) {
            return researchStack;
        }
        return null;
    }

    public void addResearchToCompleted(ResearchStack researchStack) {
        if (researchStack.getResearch() != null && !this.completedResearch.contains(researchStack)) {
            this.completedResearch.add(researchStack);
        }
    }

    public void onEvent(Event event) {
        if (this.researchCapability != null && this.researchCapability.getPlayer() != null) {
            for (int i = 0; i < this.activeResearch.size(); ++i) {
                ResearchState researchState;
                if (this.activeResearch.get(i).getResearch() != null && (researchState = this.activeResearch.get(i).getResearch().onEvent(this.activeResearch.get(i), event, (EntityPlayer)this.researchCapability.getPlayer())) != null && !(this.researchCapability.getPlayer() instanceof EntityPlayerMP)) continue;
            }
        }
    }

    public void clearActiveResearch() {
        this.activeResearch.clear();
    }

    public void clearCompletedResearch() {
        this.completedResearch.clear();
    }

    public void removeResearch(ResearchStack researchStack) {
        this.activeResearch.remove(researchStack);
    }

    public ResearchStack removeResearch(int id) {
        return this.activeResearch.remove(id);
    }

    public List<ResearchStack> getActiveResearch() {
        return this.activeResearch;
    }

    public List<ResearchStack> getCompletedResearch() {
        return this.completedResearch;
    }

    public static enum DataType {
        ACTIVE_RESEARCH,
        COMPLETED_RESEARCH;

    }
}

