/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.research;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.rom.api.research.IResearch;
import net.rom.api.research.IResearchLogic;
import net.rom.api.research.IResearchReward;
import net.rom.api.research.Research;
import net.rom.api.research.ResearchLogicState;
import net.rom.api.research.ResearchStack;
import net.rom.api.research.ResearchState;
import net.rom.exoplanets.ExoplanetsMod;

public class GenericResearch
extends Research {
    protected IResearchLogic researchLogic;

    public GenericResearch(String title, JsonObject researchObj, IResearchLogic researchLogic) {
        super(title, researchObj);
        this.researchLogic = researchLogic;
    }

    public GenericResearch(IResearchLogic researchLogic, String title, int xpReward) {
        super(title, xpReward);
        this.researchLogic = researchLogic;
    }

    @Override
    public boolean canBeAccepted(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public String getTitle(ResearchStack researchStack) {
        return this.researchLogic.modifyTitle(researchStack, ExoplanetsMod.translate.translate("research." + this.title + ".title", new Object[0]));
    }

    @Override
    public String getTitle(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.researchLogic.modifyTitle(researchStack, this.replaceVariables(ExoplanetsMod.translate.translate("research." + this.title + ".title", new Object[0]), entityPlayer));
    }

    @Override
    public String getInfo(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.researchLogic.modifyInfo(researchStack, this.replaceVariables(ExoplanetsMod.translate.translate("research." + this.title + ".info", new Object[0]), entityPlayer));
    }

    @Override
    public String getObjective(ResearchStack researchStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.researchLogic.modifyObjective(researchStack, entityPlayer, this.replaceVariables(ExoplanetsMod.translate.translate("research." + this.title + ".objective." + objectiveIndex, new Object[0]), entityPlayer), objectiveIndex);
    }

    @Override
    public int getObjectivesCount(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.researchLogic.modifyObjectiveCount(researchStack, entityPlayer, 1);
    }

    @Override
    public boolean isObjectiveCompleted(ResearchStack researchStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.researchLogic.isObjectiveCompleted(researchStack, entityPlayer, objectiveIndex);
    }

    @Override
    public boolean areResearchStacksEqual(ResearchStack researchStackOne, ResearchStack researchStackTwo) {
        if (researchStackOne.getResearch() instanceof GenericResearch && researchStackTwo.getResearch() instanceof GenericResearch && ((GenericResearch)researchStackOne.getResearch()).getResearchLogic() == ((GenericResearch)researchStackTwo.getResearch()).getResearchLogic()) {
            return ((GenericResearch)researchStackTwo.getResearch()).getResearchLogic().areResearchStacksEqual(researchStackOne, researchStackTwo);
        }
        return false;
    }

    @Override
    public void initResearchStack(Random random, ResearchStack researchStack) {
        this.researchLogic.initResearchStack(random, researchStack);
    }

    @Override
    public void initResearchStack(Random random, ResearchStack researchStack, EntityPlayer entityPlayer) {
    }

    @Override
    public ResearchState onEvent(ResearchStack researchStack, Event event, EntityPlayer entityPlayer) {
        ResearchLogicState state = this.researchLogic.onEvent(researchStack, event, entityPlayer);
        if (state == null) {
            return null;
        }
        return new ResearchState(state.getType(), new int[]{0}, state.isShowOnHud());
    }

    @Override
    public void onCompleted(ResearchStack researchStack, EntityPlayer entityPlayer) {
        this.researchLogic.onResearchCompleted(researchStack, entityPlayer);
    }

    @Override
    public int getXpReward(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.researchLogic.modifyXP(researchStack, entityPlayer, this.xpReward);
    }

    @Override
    public void addToRewards(ResearchStack researchStack, EntityPlayer entityPlayer, List<IResearchReward> rewards) {
        rewards.addAll(this.researchRewards);
        this.researchLogic.modifyRewards(researchStack, entityPlayer, rewards);
    }

    public String replaceVariables(String text, EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            return text.replace("$player", entityPlayer.func_145748_c_().func_150254_d());
        }
        return text;
    }

    public IResearchLogic getResearchLogic() {
        return this.researchLogic;
    }

    public void setResearchLogic(IResearchLogic researchLogic) {
        this.researchLogic = researchLogic;
    }

    @Override
    public IResearch getResearchByName(String researchName) {
        return null;
    }
}

