/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.rom.exoplanets.Assets;
import net.rom.exoplanets.client.render.RocketRenderer;
import net.rom.exoplanets.content.entity.EntityTwoPlayerRocket;
import net.rom.exoplanets.events.BetaGuiHandler;
import net.rom.exoplanets.events.ClientHandler;
import net.rom.exoplanets.events.SkyProviders;
import net.rom.exoplanets.init.ExoFluids;
import net.rom.exoplanets.init.ExoItems;
import net.rom.exoplanets.internal.StellarRegistry;
import net.rom.exoplanets.internal.client.ExoModelLoader;
import net.rom.exoplanets.proxy.ExoCommonProxy;

public class ExoClientProxy
extends ExoCommonProxy {
    @Override
    public void preInit(StellarRegistry registry, FMLPreInitializationEvent event) {
        super.preInit(registry, event);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ExoModelLoader.instance);
        ExoModelLoader.instance.addDomain("exoplanets");
        this.register_event(this);
        this.registerVarients();
        RenderingRegistry.registerEntityRenderingHandler(EntityTwoPlayerRocket.class, manager -> new RocketRenderer(manager));
        this.register_event(new BetaGuiHandler());
        this.register_event(new ClientHandler());
        this.register_event(new SkyProviders());
        registry.clientPreInit(event);
        ExoFluids.bakeModels();
    }

    @Override
    public void init(StellarRegistry registry, FMLInitializationEvent event) {
        super.init(registry, event);
        registry.clientInit(event);
    }

    @Override
    public void postInit(StellarRegistry registry, FMLPostInitializationEvent event) {
        super.postInit(registry, event);
        this.registerTextureAssets();
        registry.clientPostInit(event);
    }

    @Override
    public void registerTextureAssets() {
        Assets.addTexture("GuiDiscordButton", "textures/gui/discord.png");
        Assets.addTexture("GuiBetaBackground", "textures/gui/teleport.png");
        Assets.addTexture("tdeco", "textures/gui/container/tab_decoration.png");
        Assets.addTexture("tterrain", "textures/gui/container/tab_terrain.png");
        Assets.addTexture("titems", "textures/gui/container/tab_decoration.png");
    }

    public World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void register_event(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
    }

    public void registerVarients() {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("exoplanets:twopersonrocket", "inventory");
        for (int i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)ExoItems.passengerRocket, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
    }
}

