/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world.gen.feature;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.rom.exoplanets.ExoplanetsMod;

public class TreeData {
    public boolean firstLog = false;
    public boolean firstLeaves = false;
    public int minXLog = 0;
    public int maxXLog = 0;
    public int minZLog = 0;
    public int maxZLog = 0;
    public int minXLeaves = 0;
    public int maxXLeaves = 0;
    public int minZLeaves = 0;
    public int maxZLeaves = 0;
    public int logRangeX = 0;
    public int logRangeZ = 0;
    public int leavesRangeX = 0;
    public int leavesRangeZ = 0;

    public void placeLogBlock(World world, BlockPos pos, IBlockState logBlock, int generateFlag) {
        if (this.firstLog) {
            this.minXLog = pos.func_177958_n() < this.minXLog ? pos.func_177958_n() : this.minXLog;
            this.maxXLog = pos.func_177958_n() > this.maxXLog ? pos.func_177958_n() : this.maxXLog;
            this.minZLog = pos.func_177952_p() < this.minZLog ? pos.func_177952_p() : this.minZLog;
            this.maxZLog = pos.func_177952_p() > this.maxZLog ? pos.func_177952_p() : this.maxZLog;
        } else {
            this.minXLog = pos.func_177958_n();
            this.maxXLog = pos.func_177958_n();
            this.minZLog = pos.func_177952_p();
            this.maxZLog = pos.func_177952_p();
            this.firstLog = true;
        }
        this.updateRanges();
    }

    public void placeLeavesBlock(World world, BlockPos pos, IBlockState logBlock, int generateFlag) {
        if (this.firstLeaves) {
            this.minXLeaves = pos.func_177958_n() < this.minXLeaves ? pos.func_177958_n() : this.minXLeaves;
            this.maxXLeaves = pos.func_177958_n() > this.maxXLeaves ? pos.func_177958_n() : this.maxXLeaves;
            this.minZLeaves = pos.func_177952_p() < this.minZLeaves ? pos.func_177952_p() : this.minZLeaves;
            this.maxZLeaves = pos.func_177952_p() > this.maxZLeaves ? pos.func_177952_p() : this.maxZLeaves;
        } else {
            this.minXLeaves = pos.func_177958_n();
            this.maxXLeaves = pos.func_177958_n();
            this.minZLeaves = pos.func_177952_p();
            this.maxZLeaves = pos.func_177952_p();
            this.firstLeaves = true;
        }
        this.updateRanges();
    }

    public void dumpTreeData() {
        if (this.logRangeX > 16) {
            ExoplanetsMod.logger.error("Log X range = {} to {} ({} blocks)", this.minXLog, this.maxXLog, this.logRangeX);
        }
        if (this.logRangeZ > 16) {
            ExoplanetsMod.logger.error("Log Z range = {} to {} ({} blocks)", this.minZLog, this.maxZLog, this.logRangeZ);
        }
        if (this.leavesRangeX > 16) {
            ExoplanetsMod.logger.error("Leaves X range = {} to {} ({} blocks)", this.minXLeaves, this.maxXLeaves, this.leavesRangeX);
        }
        if (this.leavesRangeZ > 16) {
            ExoplanetsMod.logger.error("Leaves Z range = {} to {} ({} blocks)", this.minZLeaves, this.maxZLeaves, this.leavesRangeZ);
        }
    }

    public void updateRanges() {
        this.logRangeX = Math.abs(this.maxXLog - this.minXLog);
        this.logRangeZ = Math.abs(this.maxZLog - this.minZLog);
        this.leavesRangeX = Math.abs(this.maxXLeaves - this.minXLeaves);
        this.leavesRangeZ = Math.abs(this.maxZLeaves - this.minZLeaves);
    }
}

