/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.rom.exoplanets.internal.BlockUtil;
import net.rom.exoplanets.internal.world.gen.feature.TreeData;

public abstract class ExoTree
extends WorldGenAbstractTree {
    protected IBlockState logBlock;
    protected IBlockState leavesBlock;
    protected int trunkSize;
    protected int crownSize;
    protected boolean noLeaves;
    protected boolean treesCanGenerateOnSand;
    protected IBlockState saplingBlock;
    protected int generateFlag;
    protected int minTrunkSize;
    protected int maxTrunkSize;
    protected int minCrownSize;
    protected int maxCrownSize;
    protected ArrayList<IBlockState> validGroundBlocks;
    protected ArrayList<Material> canGrowIntoMaterials;

    public ExoTree(boolean notify) {
        super(notify);
    }

    public ExoTree() {
        this(false);
        this.setLogBlock(Blocks.field_150364_r.func_176223_P());
        this.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        this.trunkSize = 2;
        this.crownSize = 4;
        this.setNoLeaves(false);
        this.setTreesCanGenerateOnSand(false);
        this.saplingBlock = Blocks.field_150345_g.func_176223_P();
        this.generateFlag = 2;
        this.setMinTrunkSize(0);
        this.setMaxTrunkSize(0);
        this.setMinCrownSize(0);
        this.setMaxCrownSize(0);
        this.validGroundBlocks = new ArrayList<IBlockState>(Arrays.asList(Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), BlockUtil.getStateDirt(BlockDirt.DirtType.PODZOL), BlockUtil.getStateSand(BlockSand.EnumType.RED_SAND)));
        this.canGrowIntoMaterials = new ArrayList<Material>(Arrays.asList(Material.field_151579_a, Material.field_151575_d, Material.field_151584_j, Material.field_151577_b, Material.field_151578_c, Material.field_151585_k, Material.field_151582_l, Material.field_151586_h, Material.field_151597_y));
    }

    public void buildTrunk(World world, Random rand, int x, int y, int z) {
    }

    public void buildBranch(World world, Random rand, int x, int y, int z, int dX, int dZ, int logLength, int leaveSize) {
    }

    public void buildLeaves(World world, int x, int y, int z) {
    }

    public void buildLeaves(World world, Random rand, int x, int y, int z, int size) {
    }

    protected boolean isGroundValid(World world, BlockPos trunkPos) {
        return this.isGroundValid(world, trunkPos, this.treesCanGenerateOnSand);
    }

    protected boolean isGroundValid(World world, BlockPos trunkPos, boolean sandAllowed) {
        IBlockState g = world.func_180495_p(new BlockPos(trunkPos.func_177958_n(), trunkPos.func_177956_o() - 1, trunkPos.func_177952_p()));
        if (g.func_177230_c() == Blocks.field_150354_m && !sandAllowed) {
            return false;
        }
        for (int i = 0; i < this.validGroundBlocks.size(); ++i) {
            if (g != this.validGroundBlocks.get(i)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroundValid(World world, ArrayList<BlockPos> trunkPos) {
        if (trunkPos.isEmpty()) {
            throw new RuntimeException("Unable to determine if ground is valid. No trunks.");
        }
        for (int i = 0; i < trunkPos.size(); ++i) {
            if (this.isGroundValid(world, trunkPos.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void placeLogBlock(World world, BlockPos pos, IBlockState logBlock, int generateFlag) {
        if (this.isReplaceable(world, pos)) {
            world.func_180501_a(pos, logBlock, generateFlag);
        }
    }

    protected void placeLeavesBlock(World world, BlockPos pos, IBlockState leavesBlock, int generateFlag) {
        if (world.func_175623_d(pos)) {
            world.func_180501_a(pos, leavesBlock, generateFlag);
        }
    }

    protected void placeLogBlock(World world, BlockPos pos, IBlockState logBlock, int generateFlag, TreeData treeData) {
        this.placeLogBlock(world, pos, logBlock, generateFlag);
    }

    protected void placeLeavesBlock(World world, BlockPos pos, IBlockState leavesBlock, int generateFlag, TreeData treeData) {
        this.placeLeavesBlock(world, pos, leavesBlock, generateFlag);
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.func_150523_a(state.func_177230_c());
    }

    protected boolean func_150523_a(Block block) {
        if (block instanceof BlockPlanks) {
            return false;
        }
        Material material = block.func_176223_P().func_185904_a();
        for (int i = 0; i < this.canGrowIntoMaterials.size(); ++i) {
            if (material != this.canGrowIntoMaterials.get(i)) continue;
            return true;
        }
        return false;
    }

    public IBlockState getTrunkLog(IBlockState defaultLog) {
        IBlockState trunkLog;
        try {
            trunkLog = defaultLog.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        }
        catch (Exception e) {
            trunkLog = defaultLog;
        }
        return trunkLog;
    }

    public IBlockState getLogBlock() {
        return this.logBlock;
    }

    public ExoTree setLogBlock(IBlockState logBlock) {
        this.logBlock = logBlock;
        return this;
    }

    public IBlockState getLeavesBlock() {
        return this.leavesBlock;
    }

    public ExoTree setLeavesBlock(IBlockState leavesBlock) {
        this.leavesBlock = leavesBlock;
        return this;
    }

    public int getTrunkSize() {
        return this.trunkSize;
    }

    public ExoTree setTrunkSize(int trunkSize) {
        this.trunkSize = trunkSize;
        return this;
    }

    public int getCrownSize() {
        return this.crownSize;
    }

    public ExoTree setCrownSize(int crownSize) {
        this.crownSize = crownSize;
        return this;
    }

    public boolean getNoLeaves() {
        return this.noLeaves;
    }

    public ExoTree setNoLeaves(boolean noLeaves) {
        this.noLeaves = noLeaves;
        return this;
    }

    public ExoTree setTreesCanGenerateOnSand(boolean notOnSand) {
        this.treesCanGenerateOnSand = notOnSand;
        return this;
    }

    public IBlockState getSaplingBlock() {
        return this.saplingBlock;
    }

    public ExoTree setSaplingBlock(IBlockState saplingBlock) {
        this.saplingBlock = saplingBlock;
        return this;
    }

    public int getGenerateFlag() {
        return this.generateFlag;
    }

    public ExoTree setGenerateFlag(int generateFlag) {
        this.generateFlag = generateFlag;
        return this;
    }

    public int getMinTrunkSize() {
        return this.minTrunkSize;
    }

    public ExoTree setMinTrunkSize(int minTrunkSize) {
        this.minTrunkSize = minTrunkSize;
        return this;
    }

    public int getMaxTrunkSize() {
        return this.maxTrunkSize;
    }

    public ExoTree setMaxTrunkSize(int maxTrunkSize) {
        this.maxTrunkSize = maxTrunkSize;
        return this;
    }

    public int getMinCrownSize() {
        return this.minCrownSize;
    }

    public ExoTree setMinCrownSize(int minCrownSize) {
        this.minCrownSize = minCrownSize;
        return this;
    }

    public int getMaxCrownSize() {
        return this.maxCrownSize;
    }

    public ExoTree setMaxCrownSize(int maxCrownSize) {
        this.maxCrownSize = maxCrownSize;
        return this;
    }

    public ArrayList<IBlockState> getValidGroundBlocks() {
        return this.validGroundBlocks;
    }

    public ExoTree setValidGroundBlocks(ArrayList<IBlockState> validGroundBlocks) {
        this.validGroundBlocks = validGroundBlocks;
        return this;
    }
}

