/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.rom.exoplanets.astronomy.trappist1.TrappistBlocks;
import net.rom.exoplanets.internal.world.gen.feature.ExoTree;

public class ExoSempervirens
extends ExoTree {
    public ExoSempervirens(Block log, Block leaves) {
        this.setLogBlock(log.func_185499_a(log.func_176223_P(), Rotation.CLOCKWISE_90));
        this.setLeavesBlock(leaves.func_176223_P());
        this.trunkSize = 10;
        this.setValidGroundBlocks(new ArrayList<IBlockState>(Arrays.asList(TrappistBlocks.TrappistE.trap1e_grass.func_176223_P())));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int k;
        int j;
        int small;
        int i;
        if (!this.isGroundValid(world, pos)) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (i = 0; i < this.trunkSize; ++i) {
            this.placeLogBlock(world, new BlockPos(x, y, z), this.logBlock, this.generateFlag);
            ++y;
        }
        int large = small = (int)Math.ceil(this.crownSize / 2);
        for (i = 0; i < large; ++i) {
            if (!this.noLeaves) {
                for (j = -2; j <= 2; ++j) {
                    for (k = -2; k <= 2; ++k) {
                        if (Math.abs(j) + Math.abs(k) == 4 || (j <= -2 || k <= -2 || j >= 2 || k >= 2) && rand.nextInt(4) == 0) continue;
                        this.placeLeavesBlock(world, new BlockPos(x + j, y, z + k), this.leavesBlock, this.generateFlag);
                    }
                }
            }
            this.placeLogBlock(world, new BlockPos(x, y, z), this.logBlock, this.generateFlag);
            ++y;
        }
        for (i = 0; i < small; ++i) {
            if (!this.noLeaves) {
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        if (Math.abs(j) + Math.abs(k) >= 2 && rand.nextInt(4) == 0) continue;
                        this.placeLeavesBlock(world, new BlockPos(x + j, y, z + k), this.leavesBlock, this.generateFlag);
                    }
                }
                if (i == 0) {
                    this.placeLeavesBlock(world, new BlockPos(x + 1, y, z), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x - 1, y, z), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x, y, z + 1), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x, y, z - 1), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x + 2, y, z), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x - 2, y, z), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x, y, z + 2), this.leavesBlock, this.generateFlag);
                    this.placeLeavesBlock(world, new BlockPos(x, y, z - 2), this.leavesBlock, this.generateFlag);
                }
            }
            this.placeLogBlock(world, new BlockPos(x, y, z), this.logBlock, this.generateFlag);
            ++y;
        }
        this.placeLogBlock(world, new BlockPos(x, y, z), this.logBlock, this.generateFlag);
        if (!this.noLeaves) {
            this.placeLeavesBlock(world, new BlockPos(x + 1, y, z), this.leavesBlock, this.generateFlag);
            this.placeLeavesBlock(world, new BlockPos(x - 1, y, z), this.leavesBlock, this.generateFlag);
            this.placeLeavesBlock(world, new BlockPos(x, y, z + 1), this.leavesBlock, this.generateFlag);
            this.placeLeavesBlock(world, new BlockPos(x, y, z - 1), this.leavesBlock, this.generateFlag);
            this.placeLeavesBlock(world, new BlockPos(x, y + 1, z), this.leavesBlock, this.generateFlag);
            this.placeLeavesBlock(world, new BlockPos(x, y + 2, z), this.leavesBlock, this.generateFlag);
        }
        return true;
    }
}

