/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world.gen;

import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.rom.exoplanets.internal.world.gen.MapGenBaseMeta;

public class MapGenExoCave
extends MapGenBaseMeta {
    private IBlockState top = Blocks.field_150349_c.func_176223_P();
    private IBlockState lava = Blocks.field_150353_l.func_176223_P();
    private Set<Block> topBlock = new HashSet<Block>();
    private Set<Block> digBlock = new HashSet<Block>();
    private Set<Block> fluidBlock = new HashSet<Block>();

    public MapGenExoCave(Set<Block> topBlock, IBlockState lava, Set<Block> digBlock, Set<Block> fluidBlock) {
        this.topBlock = topBlock;
        this.lava = lava;
        this.digBlock = digBlock;
        this.fluidBlock = fluidBlock;
    }

    public MapGenExoCave(IBlockState top, IBlockState lava, Set<Block> digBlock) {
        this(top, lava, digBlock, new HashSet<Block>());
    }

    public MapGenExoCave(IBlockState top, IBlockState lava, Set<Block> digBlock, Set<Block> fluidBlock) {
        this.top = top;
        this.lava = lava;
        this.digBlock = digBlock;
        this.fluidBlock = fluidBlock;
    }

    @Override
    protected void recursiveGenerate(World world, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer primer) {
        int i = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(15) + 1) + 1);
        if (this.rand.nextInt(7) != 0) {
            i = 0;
        }
        for (int j = 0; j < i; ++j) {
            double d0 = chunkX * 16 + this.rand.nextInt(16);
            double d1 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            double d2 = chunkZ * 16 + this.rand.nextInt(16);
            int k = 1;
            if (this.rand.nextInt(4) == 0) {
                this.addRoom(this.rand.nextLong(), originalX, originalZ, primer, d0, d1, d2);
                k += this.rand.nextInt(4);
            }
            for (int l = 0; l < k; ++l) {
                float f = this.rand.nextFloat() * ((float)Math.PI * 2);
                float f1 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = this.rand.nextFloat() * 2.0f + this.rand.nextFloat();
                if (this.rand.nextInt(10) == 0) {
                    f2 *= this.rand.nextFloat() * this.rand.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(this.rand.nextLong(), originalX, originalZ, primer, d0, d1, d2, f2, f, f1, 0, 0, 1.0);
            }
        }
    }

    private void addRoom(long seed, int originalX, int originalZ, ChunkPrimer primer, double x, double y, double z) {
        this.addTunnel(seed, originalX, originalZ, primer, x, y, z, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    private void addTunnel(long seed, int originalX, int originalZ, ChunkPrimer primer, double x, double y, double z, float p_180702_12_, float p_180702_13_, float p_180702_14_, int p_180702_15_, int p_180702_16_, double p_180702_17_) {
        boolean flag;
        double d0 = originalX * 16 + 8;
        double d1 = originalZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random rand = new Random(seed);
        if (p_180702_16_ <= 0) {
            int i = this.range * 16 - 16;
            p_180702_16_ = i - rand.nextInt(i / 4);
        }
        boolean flag2 = false;
        if (p_180702_15_ == -1) {
            p_180702_15_ = p_180702_16_ / 2;
            flag2 = true;
        }
        int j = rand.nextInt(p_180702_16_ / 2) + p_180702_16_ / 4;
        boolean bl = flag = rand.nextInt(6) == 0;
        while (p_180702_15_ < p_180702_16_) {
            double d2 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)p_180702_15_ * (float)Math.PI / (float)p_180702_16_)) * p_180702_12_);
            double d3 = d2 * p_180702_17_;
            float f2 = MathHelper.func_76134_b((float)p_180702_14_);
            float f3 = MathHelper.func_76126_a((float)p_180702_14_);
            x += (double)(MathHelper.func_76134_b((float)p_180702_13_) * f2);
            y += (double)f3;
            z += (double)(MathHelper.func_76126_a((float)p_180702_13_) * f2);
            p_180702_14_ = flag ? (p_180702_14_ *= 0.92f) : (p_180702_14_ *= 0.7f);
            p_180702_14_ += f1 * 0.1f;
            p_180702_13_ += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            f += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (!flag2 && p_180702_15_ == j && p_180702_12_ > 1.0f && p_180702_16_ > 0) {
                this.addTunnel(rand.nextLong(), originalX, originalZ, primer, x, y, z, rand.nextFloat() * 0.5f + 0.5f, p_180702_13_ - 1.5707964f, p_180702_14_ / 3.0f, p_180702_15_, p_180702_16_, 1.0);
                this.addTunnel(rand.nextLong(), originalX, originalZ, primer, x, y, z, rand.nextFloat() * 0.5f + 0.5f, p_180702_13_ + 1.5707964f, p_180702_14_ / 3.0f, p_180702_15_, p_180702_16_, 1.0);
                return;
            }
            if (flag2 || rand.nextInt(4) != 0) {
                double d4 = x - d0;
                double d5 = z - d1;
                double d6 = p_180702_16_ - p_180702_15_;
                double d7 = p_180702_12_ + 2.0f + 16.0f;
                if (d4 * d4 + d5 * d5 - d6 * d6 > d7 * d7) {
                    return;
                }
                if (x >= d0 - 16.0 - d2 * 2.0 && z >= d1 - 16.0 - d2 * 2.0 && x <= d0 + 16.0 + d2 * 2.0 && z <= d1 + 16.0 + d2 * 2.0) {
                    int k2 = MathHelper.func_76128_c((double)(x - d2)) - originalX * 16 - 1;
                    int k = MathHelper.func_76128_c((double)(x + d2)) - originalX * 16 + 1;
                    int l2 = MathHelper.func_76128_c((double)(y - d3)) - 1;
                    int l = MathHelper.func_76128_c((double)(y + d3)) + 1;
                    int i3 = MathHelper.func_76128_c((double)(z - d2)) - originalZ * 16 - 1;
                    int i1 = MathHelper.func_76128_c((double)(z + d2)) - originalZ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean flag3 = false;
                    for (int j1 = k2; !flag3 && j1 < k; ++j1) {
                        for (int k1 = i3; !flag3 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag3 && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(primer, j1, l1, k1, originalX, originalZ)) {
                                    flag3 = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!flag3) {
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + originalX * 16) + 0.5 - x) / d2;
                            for (int i2 = i3; i2 < i1; ++i2) {
                                double d8 = ((double)(i2 + originalZ * 16) + 0.5 - z) / d2;
                                boolean flag1 = false;
                                if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d9 = ((double)(j2 - 1) + 0.5 - y) / d3;
                                    if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                    IBlockState iblockstate1 = primer.func_177856_a(j3, j2, i2);
                                    IBlockState iblockstate2 = (IBlockState)MoreObjects.firstNonNull((Object)primer.func_177856_a(j3, j2 + 1, i2), (Object)Blocks.field_150350_a.func_176223_P());
                                    if (this.isTopBlock(primer, j3, j2, i2, originalX, originalZ)) {
                                        flag1 = true;
                                    }
                                    this.digBlock(primer, j3, j2, i2, originalX, originalZ, flag1, iblockstate1, iblockstate2);
                                }
                            }
                        }
                        if (flag2) break;
                    }
                }
            }
            ++p_180702_15_;
        }
    }

    private boolean canReplaceBlock(IBlockState state, IBlockState up) {
        for (Block block : this.digBlock) {
            if (!state.func_177230_c().equals(block)) continue;
            return true;
        }
        return state.func_177230_c() == this.top.func_177230_c();
    }

    private boolean isOceanBlock(ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        Block block = primer.func_177856_a(x, y, z).func_177230_c();
        if (this.fluidBlock.isEmpty()) {
            return false;
        }
        for (Block fluidBlock : this.fluidBlock) {
            if (!fluidBlock.equals(block)) continue;
            return true;
        }
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
    }

    private boolean isTopBlock(ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        IBlockState state = primer.func_177856_a(x, y, z);
        if (this.topBlock.isEmpty()) {
            return false;
        }
        for (Block topBlock : this.topBlock) {
            if (!topBlock.equals(state.func_177230_c())) continue;
            return true;
        }
        return state.func_177230_c() == this.top.func_177230_c();
    }

    private void digBlock(ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up) {
        Biome biome = this.worldObj.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (this.canReplaceBlock(state, up) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
            if (y - 1 < 10) {
                primer.func_177855_a(x, y, z, this.lava);
            } else {
                primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                if (foundTop && primer.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                    primer.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
                }
            }
        }
    }
}

