/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world.gen;

import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.rom.exoplanets.internal.world.gen.GenExoplanetLake;

public class GenUtility {
    public static void generateStructure(WorldGenerator worldGen, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
        worldGen.func_180709_b(world, rand, new BlockPos(x, y, z));
    }

    public static void generateStructureWithRandomY(WorldGenerator worldGen, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        GenUtility.generateStructureWithSetY(worldGen, world, rand, new BlockPos(x, pos.func_177956_o(), z), pos.func_177956_o());
    }

    public static void generateStructureWithSetY(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int y) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        worldGen.func_180709_b(world, rand, new BlockPos(x, y, z));
    }

    public static void generateStructureWithRangeY(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int minY, int maxY) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        worldGen.func_180709_b(world, rand, new BlockPos(x, rand.nextInt(maxY) + minY, z));
    }

    public static void generateStructureWithRangeY(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int minY, int maxY, int chance, Set<Biome> set) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        worldGen.func_180709_b(world, rand, new BlockPos(x, rand.nextInt(maxY) + minY, z));
    }

    public static void generateStructureWithRandom(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int randomAmountXZ) {
        GenUtility.generateStructure(worldGen, world, rand, pos.func_177982_a(rand.nextInt(randomAmountXZ), 0, rand.nextInt(randomAmountXZ)));
    }

    public static void generateStructureWithRandom(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int randomAmountXZ, int randomAmountY) {
        GenUtility.generateStructureWithRandomY(worldGen, world, rand, pos.func_177982_a(rand.nextInt(randomAmountXZ), rand.nextInt(randomAmountY), rand.nextInt(randomAmountXZ)));
    }

    public static void generateLakeGenStone(World world, Random rand, BlockPos pos, Block fluid, Block block) {
        IBlockState fState = fluid.func_176223_P();
        IBlockState bState = block.func_176223_P();
        new GenExoplanetLake(fState, bState, true);
    }

    public static void generateLake(World world, Random rand, BlockPos pos, Block fluid, Block block) {
        IBlockState fState = fluid.func_176223_P();
        IBlockState bState = block.func_176223_P();
        new GenExoplanetLake(fState, bState, false);
    }

    public static HashMap<BlockPos, IBlockState> generateSphereHollow(IBlockState state, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int yy = -halfSize; yy < halfSize + 1; ++yy) {
                for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                    for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                        BlockPos loc = new BlockPos(xx, yy, zz);
                        double dist = Math.abs(loc.func_185332_f(0, 0, 0));
                        if (!(dist <= (double)(halfSize - i)) || !(dist > (double)(halfSize - (i + 1))) || i != 0) continue;
                        blocks.put(pos.func_177982_a(xx, yy, zz), state);
                    }
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, IBlockState> generateSphere(IBlockState state1, IBlockState state2, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int yy = -halfSize; yy < halfSize + 1; ++yy) {
                for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                    for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                        BlockPos loc = new BlockPos(xx, yy, zz);
                        double dist = Math.abs(loc.func_185332_f(0, 0, 0));
                        if (!(dist <= (double)(halfSize - i)) || !(dist > (double)(halfSize - (i + 1)))) continue;
                        if (i == 0) {
                            blocks.put(pos.func_177982_a(xx, yy, zz), state1);
                            continue;
                        }
                        blocks.put(pos.func_177982_a(xx, yy, zz), state2);
                    }
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, IBlockState> generateSphere(IBlockState state, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int yy = -halfSize; yy < halfSize + 1; ++yy) {
                for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                    for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                        BlockPos loc = new BlockPos(xx, yy, zz);
                        double dist = Math.abs(loc.func_185332_f(0, 0, 0));
                        if (!(dist <= (double)(halfSize - i)) || !(dist > (double)(halfSize - (i + 1)))) continue;
                        blocks.put(pos.func_177982_a(xx, yy, zz), state);
                    }
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, IBlockState> generateCube(IBlockState state, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int yy = -halfSize; yy < halfSize + 1; ++yy) {
                for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                    for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                        blocks.put(pos.func_177982_a(xx, yy, zz), state);
                    }
                }
            }
        }
        return blocks;
    }

    public HashMap<BlockPos, IBlockState> generateDome(IBlockState state, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int yy = 0; yy < halfSize + 1; ++yy) {
                for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                    for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                        BlockPos loc = new BlockPos(xx, yy, zz);
                        double dist = Math.abs(loc.func_185332_f(0, 0, 0));
                        if (!(dist <= (double)(halfSize - i)) || !(dist > (double)(halfSize - (i + 1))) || i != 0) continue;
                        blocks.put(pos.func_177982_a(xx, yy, zz), state);
                    }
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, IBlockState> generateCircle(IBlockState state, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                    BlockPos loc = new BlockPos(xx, 0, zz);
                    double dist = Math.abs(loc.func_185332_f(0, 0, 0));
                    if (!(dist <= (double)(halfSize - i)) || !(dist > (double)(halfSize - (i + 1))) || i != 0) continue;
                    blocks.put(pos.func_177982_a(xx, 0, zz), state);
                }
            }
        }
        return blocks;
    }

    public static HashMap<BlockPos, IBlockState> generatessSquare(IBlockState state, int size, BlockPos pos) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int halfSize = size / 2;
        for (int i = 0; i <= halfSize; ++i) {
            for (int zz = -halfSize; zz < halfSize + 1; ++zz) {
                for (int xx = -halfSize; xx < halfSize + 1; ++xx) {
                    blocks.put(pos.func_177982_a(xx, 0, zz), state);
                }
            }
        }
        return blocks;
    }

    public static boolean checkValidSpawn(World world, BlockPos position, int checkSize, int loadedCheckSize) {
        if (!world.func_175697_a(position, loadedCheckSize)) {
            return false;
        }
        position = position.func_177982_a(0, 0, 0);
        while (position.func_177956_o() > 5 && world.func_175623_d(position) || world.func_180495_p(position).func_185904_a().func_76224_d()) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() <= 4) {
            return false;
        }
        for (int i = -checkSize; i <= checkSize; ++i) {
            for (int j = -checkSize; j <= checkSize; ++j) {
                if ((!world.func_175623_d(position.func_177982_a(i, -1, j)) || !world.func_175623_d(position.func_177982_a(i, -2, j))) && (!world.func_180495_p(position.func_177982_a(i, -1, j)).func_185904_a().func_76224_d() || !world.func_180495_p(position.func_177982_a(i, -2, j)).func_185904_a().func_76224_d())) continue;
                return true;
            }
        }
        return true;
    }

    public static boolean checkValidSpawn(World world, BlockPos position, int size) {
        return GenUtility.checkValidSpawn(world, position, size, size);
    }
}

