/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world.biome;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.rom.api.space.ExoPlanet;
import net.rom.exoplanets.internal.enums.EnumTPHClass;
import net.rom.exoplanets.internal.world.WorldProviderExoPlanet;
import net.rom.exoplanets.internal.world.biome.ExoPlanetBiomeBase;

public class BiomeSpace
extends ExoPlanetBiomeBase {
    protected Planet planetForBiome = null;
    protected WorldProviderExoPlanet spaceProvider = null;
    public static int grassFoliageColor = 65280;

    public BiomeSpace(Biome.BiomeProperties properties) {
        super(properties);
        this.init();
    }

    public BiomeSpace(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.init();
    }

    private void init() {
        this.clearAllSpawning();
    }

    public BiomeSpace setPlanetForBiome(Planet planet) {
        this.planetForBiome = planet;
        return this;
    }

    public Planet getPlanetForBiome() {
        return this.planetForBiome;
    }

    public BiomeSpace setSpaceProvider(WorldProviderExoPlanet provider) {
        this.spaceProvider = provider;
        return this;
    }

    public WorldProviderExoPlanet getSpaceProvider() {
        return this.spaceProvider;
    }

    public boolean getIsHotBiome() {
        return this.getBiomeTemp() >= 7.0f;
    }

    public boolean getIsColdBiome() {
        return this.getBiomeTemp() <= 3.0f;
    }

    public BiomeSpace setBlocks(Block topBlock, Block fillerBlock) {
        this.field_76752_A = topBlock.func_176223_P();
        this.field_76753_B = fillerBlock.func_176223_P();
        return this;
    }

    public BiomeSpace setTemp(float biomeTemp) {
        this.temp = biomeTemp;
        return this;
    }

    public float getBiomeTemp() {
        return this.temp;
    }

    public float getPlanetTemp() {
        float planetTemp;
        ExoPlanet planet = (ExoPlanet)this.getPlanetForBiome();
        float biomeTemp = this.getBiomeTemp();
        Random rand = new Random();
        float flucTemp = planetTemp = (float)planet.getPlanetTemp();
        float maxTemp = planetTemp + 25.0f;
        float minTemp = planetTemp - 25.0f;
        flucTemp = planet.getTphClass() == EnumTPHClass.HP || planet.getTphClass() == EnumTPHClass.P ? (flucTemp -= biomeTemp) : (planet.getTphClass() == EnumTPHClass.T || planet.getTphClass() == EnumTPHClass.HT ? (flucTemp += biomeTemp) : planetTemp + biomeTemp);
        if (planetTemp < minTemp) {
            planetTemp = minTemp;
        }
        if (planetTemp > maxTemp) {
            planetTemp = maxTemp;
        }
        return flucTemp;
    }
}

