/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.world;

import asmodeuscore.api.dimension.IAdvancedSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.api.space.ExoPlanet;
import net.rom.exoplanets.internal.world.IExoPlanetWorldProvider;

public abstract class WorldProviderExoPlanet
extends WorldProviderSpace
implements ISolarLevel,
IExitHeight,
IExoPlanetWorldProvider {
    private static WorldProviderExoPlanet instance;

    public WorldProviderExoPlanet() {
        instance = this;
    }

    public static WorldProviderExoPlanet instance() {
        return instance;
    }

    public String getSaveFolder() {
        return "planets/" + this.getExoPlanet().getName();
    }

    public World getWorldObj() {
        return this.field_76579_a;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @Override
    public ExoPlanet getExoPlanet() {
        return (ExoPlanet)this.getCelestialBody();
    }

    public abstract float getSolarSize();

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        return false;
    }

    public IRenderHandler getCloudRenderer() {
        return new CloudRenderer();
    }

    public long getDayLength() {
        return this.getExoPlanet().getDayLength();
    }

    public int AtmosphericPressure() {
        return 5;
    }

    public boolean SolarRadiation() {
        return true;
    }

    public double getSolarWindMultiplier() {
        return 0.6;
    }

    public IAdvancedSpace.ClassBody getClassBody() {
        return IAdvancedSpace.ClassBody.SELENA;
    }

    public float getSolarRadiationModify() {
        return 5.0f;
    }

    public void updateWeather() {
        World worldObj = this.getWorldObj();
        WorldInfo worldInfo = worldObj.func_72912_H();
        if (!this.shouldDisablePrecipitation()) {
            super.updateWeather();
        } else {
            worldInfo.func_76080_g(0);
            worldInfo.func_76084_b(false);
            worldInfo.func_76090_f(0);
            worldInfo.func_76069_a(false);
            worldObj.field_73004_o = 0.0f;
            worldObj.field_73017_q = 0.0f;
        }
    }

    public float getWindLevel() {
        return 0.0f;
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public abstract double getMeteorFrequency();

    public float getArrowGravity() {
        return 0.003f;
    }

    public int getDungeonSpacing() {
        return 704;
    }

    public boolean hasBreathableAtmosphere() {
        return this.getExoPlanet().isBreathable();
    }

    public float getGravity() {
        return this.getExoPlanet().getGravity();
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getExoPlanet().getTierRequirement();
    }

    public boolean func_191066_m() {
        return true;
    }

    public float getPlanetTemp() {
        ExoPlanet planet = this.getExoPlanet();
        float planetTemp = (float)planet.getPlanetTemp();
        planetTemp = this.isDaytime() ? (planetTemp /= 2.2f) : (float)planet.getPlanetTemp();
        return planetTemp;
    }

    public abstract Class<? extends IChunkGenerator> getChunkProviderClass();

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.getWorldObj().func_72826_c(1.0f);
        float f2 = 1.25f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 0.8f + 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.getWorldObj().func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }
}

