/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.tile;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.activation.UnsupportedDataTypeException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.rom.exoplanets.internal.inerf.tile.INBTSerializer;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface SyncVariable {
    public String name();

    public boolean onRead() default true;

    public boolean onWrite() default true;

    public boolean onPacket() default true;

    public static final class Helper {
        static final Map<Class, Function<NBTTagCompound, ?>> READERS = new HashMap();
        static final Map<Class, Function<?, NBTTagCompound>> WRITERS = new HashMap();
        static final Map<Class, INBTSerializer> SERIALIZERS = new HashMap<Class, INBTSerializer>();

        private Helper() {
        }

        public static <T> void registerSerializer(Class<T> clazz, final Function<NBTTagCompound, T> reader, final BiConsumer<NBTTagCompound, T> writer) {
            SERIALIZERS.put(clazz, new INBTSerializer<T>(){

                @Override
                public T read(NBTTagCompound tags) {
                    return reader.apply(tags);
                }

                @Override
                public void write(NBTTagCompound tags, T obj) {
                    writer.accept(tags, obj);
                }
            });
        }

        public static void readSyncVars(Object obj, NBTTagCompound tags) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    if (!(annotation instanceof SyncVariable)) continue;
                    SyncVariable sync = (SyncVariable)annotation;
                    try {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        String name = sync.name();
                        if (field.getType() == Integer.TYPE) {
                            field.setInt(obj, tags.func_74762_e(name));
                            continue;
                        }
                        if (field.getType() == Float.TYPE) {
                            field.setFloat(obj, tags.func_74760_g(name));
                            continue;
                        }
                        if (field.getType() == String.class) {
                            field.set(obj, tags.func_74779_i(name));
                            continue;
                        }
                        if (field.getType() == Boolean.TYPE) {
                            field.setBoolean(obj, tags.func_74767_n(name));
                            continue;
                        }
                        if (field.getType() == Double.TYPE) {
                            field.setDouble(obj, tags.func_74769_h(name));
                            continue;
                        }
                        if (field.getType() == Long.TYPE) {
                            field.setLong(obj, tags.func_74763_f(name));
                            continue;
                        }
                        if (field.getType() == Short.TYPE) {
                            field.setShort(obj, tags.func_74765_d(name));
                            continue;
                        }
                        if (field.getType() == Byte.TYPE) {
                            field.setByte(obj, tags.func_74771_c(name));
                            continue;
                        }
                        if (SERIALIZERS.containsKey(field.getType())) {
                            INBTSerializer serializer = SERIALIZERS.get(field.getType());
                            NBTTagCompound compound = tags.func_74775_l(name);
                            field.set(obj, serializer.read(compound));
                            continue;
                        }
                        throw new UnsupportedDataTypeException("Don't know how to read type " + field.getType() + " from NBT!");
                    }
                    catch (IllegalAccessException | UnsupportedDataTypeException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public static NBTTagCompound writeSyncVars(Object obj, NBTTagCompound tags, Type syncType) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    if (!(annotation instanceof SyncVariable)) continue;
                    SyncVariable sync = (SyncVariable)annotation;
                    if ((syncType != Type.WRITE || !sync.onWrite()) && (syncType != Type.PACKET || !sync.onPacket())) continue;
                    try {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        String name = sync.name();
                        if (field.getType() == Integer.TYPE) {
                            tags.func_74768_a(name, field.getInt(obj));
                            continue;
                        }
                        if (field.getType() == Float.TYPE) {
                            tags.func_74776_a(name, field.getFloat(obj));
                            continue;
                        }
                        if (field.getType() == String.class) {
                            tags.func_74778_a(name, (String)field.get(obj));
                            continue;
                        }
                        if (field.getType() == Boolean.TYPE) {
                            tags.func_74757_a(name, field.getBoolean(obj));
                            continue;
                        }
                        if (field.getType() == Double.TYPE) {
                            tags.func_74780_a(name, field.getDouble(obj));
                            continue;
                        }
                        if (field.getType() == Long.TYPE) {
                            tags.func_74772_a(name, field.getLong(obj));
                            continue;
                        }
                        if (field.getType() == Short.TYPE) {
                            tags.func_74777_a(name, field.getShort(obj));
                            continue;
                        }
                        if (field.getType() == Byte.TYPE) {
                            tags.func_74774_a(name, field.getByte(obj));
                            continue;
                        }
                        if (SERIALIZERS.containsKey(field.getType())) {
                            NBTTagCompound compound = new NBTTagCompound();
                            INBTSerializer serializer = SERIALIZERS.get(field.getType());
                            serializer.write(compound, field.get(obj));
                            tags.func_74782_a(name, (NBTBase)compound);
                            continue;
                        }
                        throw new UnsupportedDataTypeException("Don't know how to write type " + field.getType() + " to NBT!");
                    }
                    catch (IllegalAccessException | UnsupportedDataTypeException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return tags;
        }
    }

    public static enum Type {
        READ,
        WRITE,
        PACKET;

    }
}

