/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.tile;

import lombok.Generated;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.ForgeEventFactory;
import net.rom.exoplanets.internal.EnumUtils;
import net.rom.exoplanets.internal.inerf.IFuelBurner;
import net.rom.exoplanets.internal.tile.SyncVariable;

public class FurnaceFuelBurner
implements IFuelBurner {
    private final BurnCondition burnCondition;
    private int timeRemaining;
    private int currentItemMaxTime;

    public FurnaceFuelBurner(BurnCondition burnCondition) {
        this.burnCondition = burnCondition;
    }

    @Override
    public boolean feedFuel(ItemStack stack) {
        int value = ForgeEventFactory.getItemBurnTime((ItemStack)stack);
        if (value > 0) {
            this.timeRemaining = this.currentItemMaxTime = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFuel() {
        return this.timeRemaining > 0;
    }

    @Override
    public boolean tickFuel(boolean isProcessing) {
        if (this.burnCondition.shouldTick(this, isProcessing)) {
            --this.timeRemaining;
            return true;
        }
        return false;
    }

    private static FurnaceFuelBurner readFromNBT(NBTTagCompound tags) {
        BurnCondition condition = EnumUtils.fromString(BurnCondition.class, tags.func_74779_i("Condition")).orElse(BurnCondition.DEFAULT);
        FurnaceFuelBurner result = new FurnaceFuelBurner(condition);
        result.timeRemaining = tags.func_74762_e("Time");
        result.currentItemMaxTime = tags.func_74762_e("MaxTime");
        return result;
    }

    private static void writeToNBT(NBTTagCompound tags, FurnaceFuelBurner burner) {
        if (burner.burnCondition != BurnCondition.DEFAULT) {
            tags.func_74778_a("Condition", burner.burnCondition.name());
        }
        tags.func_74768_a("Time", burner.timeRemaining);
        tags.func_74768_a("MaxTime", burner.currentItemMaxTime);
    }

    @Generated
    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    @Generated
    public int getCurrentItemMaxTime() {
        return this.currentItemMaxTime;
    }

    static {
        SyncVariable.Helper.registerSerializer(FurnaceFuelBurner.class, FurnaceFuelBurner::readFromNBT, FurnaceFuelBurner::writeToNBT);
    }

    public static enum BurnCondition {
        STANDARD{

            @Override
            boolean shouldTick(FurnaceFuelBurner burner, boolean processing) {
                return burner.timeRemaining > 0;
            }
        }
        ,
        ONLY_WHEN_PROCESSING{

            @Override
            boolean shouldTick(FurnaceFuelBurner burner, boolean processing) {
                return processing;
            }
        }
        ,
        ALWAYS{

            @Override
            boolean shouldTick(FurnaceFuelBurner burner, boolean processing) {
                return true;
            }
        };

        private static final BurnCondition DEFAULT;

        abstract boolean shouldTick(FurnaceFuelBurner var1, boolean var2);

        static {
            DEFAULT = STANDARD;
        }
    }
}

