/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.network;

import io.netty.channel.ChannelHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.rom.exoplanets.internal.network.packet.AbstractClientPacketHandler;

@ChannelHandler.Sharable
public class NetworkPipeline {
    public final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("exoplanets");
    protected int packetID = 0;

    public void registerPackets() {
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerPacket(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> reresearchMessageType) {
        try {
            Side side = AbstractClientPacketHandler.class.isAssignableFrom(messageHandler) ? Side.CLIENT : Side.SERVER;
            this.dispatcher.registerMessage(messageHandler, reresearchMessageType, this.packetID++, side);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendToServer(IMessage message) {
        this.dispatcher.sendToServer(message);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.dispatcher.sendToAllAround(message, point);
    }

    public void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range));
    }

    public void sendToAllAround(IMessage message, TileEntity tileEntity, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(tileEntity.func_145831_w().field_73011_w.getDimension(), (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), range));
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.dispatcher.sendTo(message, player);
    }

    public void sendToDimention(IMessage message, int dimention) {
        this.dispatcher.sendToDimension(message, dimention);
    }

    public void sendToDimention(IMessage message, World world) {
        this.sendToDimention(message, world.field_73011_w);
    }

    public void sendToDimention(IMessage message, WorldProvider worldProvider) {
        this.dispatcher.sendToDimension(message, worldProvider.getDimension());
    }
}

