/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.client;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.rom.exoplanets.ExoplanetsMod;

public class ExoModelLoader
implements ICustomModelLoader {
    public static final ExoModelLoader instance = new ExoModelLoader();
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, IModel> cache = new HashMap<ResourceLocation, IModel>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        ExoplanetsMod.logger.info("Added " + domain.toLowerCase() + " to OBJ domain list");
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        IModel model;
        block8: {
            model = null;
            if (this.cache.containsKey(modelLocation)) {
                model = this.cache.get(modelLocation);
            } else {
                String prefix = modelLocation.func_110623_a().contains("models/") ? "" : "models/";
                ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), prefix + modelLocation.func_110623_a());
                IResource resource = this.manager.func_110536_a(file);
                if (resource == null) break block8;
                OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
                try {
                    model = parser.parse().process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                }
                finally {
                    resource.func_110527_b().close();
                    this.cache.put(modelLocation, model);
                }
            }
        }
        if (model == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        return model;
    }

    static {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)instance);
    }
}

