/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ClientRenderUtils {
    public static void renderTexturedQuad(TextureAtlasSprite texture, EnumFacing face, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int brightness, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, face, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderTexturedCuboid(TextureAtlasSprite[] textures, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int brightness, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ClientRenderUtils.putTexturedQuad(renderer, textures[0], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, textures[1], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, textures[2], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, textures[3], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, textures[4], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, textures[5], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderTexturedCuboid(TextureAtlasSprite texture, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int brightness, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, false);
        ClientRenderUtils.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BufferBuilder buffer) {
        ClientRenderUtils.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, buffer);
        ClientRenderUtils.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, buffer);
        ClientRenderUtils.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, buffer);
        ClientRenderUtils.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, buffer);
        ClientRenderUtils.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, buffer);
        ClientRenderUtils.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, buffer);
    }

    public static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        ClientRenderUtils.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f, buffer);
        ClientRenderUtils.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f, buffer);
        ClientRenderUtils.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, r, g, b, a * 0.8f, buffer);
        ClientRenderUtils.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, r, g, b, a * 1.1f, buffer);
        ClientRenderUtils.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, r, g, b, a, buffer);
        ClientRenderUtils.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, r, g, b, a, buffer);
    }

    public static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181675_d();
    }

    public static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181675_d();
    }

    public static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181675_d();
    }

    public static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181675_d();
    }

    public static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181675_d();
    }

    public static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181675_d();
    }

    public static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        ClientRenderUtils.putQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2, flowing);
    }

    public static void putQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        if (sprite != null) {
            double maxV;
            double minV;
            double maxU;
            double minU;
            double zt2;
            double yt2;
            double xt2;
            double size = 16.0;
            if (flowing) {
                size = 8.0;
            }
            double x2 = x + w;
            double y2 = y + h;
            double z2 = z + d;
            double xt1 = x % 1.0;
            for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
            }
            double yt1 = y % 1.0;
            for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
            }
            double zt1 = z % 1.0;
            for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
            }
            if (flowing) {
                double tmp = 1.0 - yt1;
                yt1 = 1.0 - yt2;
                yt2 = tmp;
            }
            switch (face) {
                case DOWN: 
                case UP: {
                    minU = sprite.func_94214_a(xt1 * size);
                    maxU = sprite.func_94214_a(xt2 * size);
                    minV = sprite.func_94207_b(zt1 * size);
                    maxV = sprite.func_94207_b(zt2 * size);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    minU = sprite.func_94214_a(xt2 * size);
                    maxU = sprite.func_94214_a(xt1 * size);
                    minV = sprite.func_94207_b(yt1 * size);
                    maxV = sprite.func_94207_b(yt2 * size);
                    break;
                }
                case WEST: 
                case EAST: {
                    minU = sprite.func_94214_a(zt2 * size);
                    maxU = sprite.func_94214_a(zt1 * size);
                    minV = sprite.func_94207_b(yt1 * size);
                    maxV = sprite.func_94207_b(yt2 * size);
                    break;
                }
                default: {
                    minU = sprite.func_94209_e();
                    maxU = sprite.func_94212_f();
                    minV = sprite.func_94206_g();
                    maxV = sprite.func_94210_h();
                }
            }
            switch (face) {
                case DOWN: {
                    renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case UP: {
                    renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case NORTH: {
                    renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case SOUTH: {
                    renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case WEST: {
                    renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case EAST: {
                    renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                }
            }
        }
    }
}

