/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.internal.LogHelper;
import net.rom.exoplanets.internal.MCUtil;
import net.rom.exoplanets.internal.RecipeBuilder;
import net.rom.exoplanets.internal.block.BlockMetaSubtypes;
import net.rom.exoplanets.internal.inerf.IAddRecipe;
import net.rom.exoplanets.internal.inerf.IColorBlock;
import net.rom.exoplanets.internal.inerf.ICustomMesh;
import net.rom.exoplanets.internal.inerf.ICustomModel;
import net.rom.exoplanets.internal.inerf.ITEBlock;
import net.rom.exoplanets.internal.inerf.item.IColorItem;
import net.rom.exoplanets.internal.inerf.item.ItemBlockMetaSubtypes;

public class StellarRegistry {
    private static final Pattern PATTERN_REGISTRY_NAME = Pattern.compile("[^a-z0-9_]+");
    public final List<Block> blocks = NonNullList.func_191196_a();
    public final List<Item> items = NonNullList.func_191196_a();
    private final List<IAddRecipe> recipeAdders = NonNullList.func_191196_a();
    private final List<Block> coloredBlocks = NonNullList.func_191196_a();
    private final List<Item> coloredItems = NonNullList.func_191196_a();
    private final Map<Class<? extends IForgeRegistryEntry<?>>, Consumer<StellarRegistry>> registrationHandlers = new HashMap();
    private Object mod;
    private final LogHelper logger;
    private final String modId;
    private final String resourcePrefix;
    @Nonnull
    private final RecipeBuilder recipes;
    @Nullable
    private CreativeTabs defaultCreativeTab = null;
    @Nullable
    private boolean registerJsonFiles;
    @Nullable
    private CreativeTabs creativeTab = null;
    private int lastEntityId = -1;
    private boolean preInitDone = false;
    private boolean initDone = false;
    private boolean postInitDone = false;

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public StellarRegistry() {
        ModContainer mod = Objects.requireNonNull(Loader.instance().activeModContainer());
        this.modId = mod.getModId();
        this.resourcePrefix = this.modId + ":";
        this.logger = ExoplanetsMod.logger;
        this.recipes = new RecipeBuilder(this.modId);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler(this));
    }

    public RecipeBuilder getRecipeMaker() {
        return this.recipes;
    }

    public void setMod(Object mod) {
        this.mod = mod;
    }

    public void generateJsonFiles(boolean makeJson) {
        this.registerJsonFiles = makeJson;
    }

    public void addRegistrationHandler(Consumer<StellarRegistry> registerFunction, Class<? extends IForgeRegistryEntry<?>> registryClass) throws RuntimeException {
        if (this.registrationHandlers.containsKey(registryClass)) {
            throw new RuntimeException("Registration handler for class " + registryClass + " already registered!");
        }
        this.registrationHandlers.put(registryClass, registerFunction);
    }

    public <T extends Block> T registerBlock(T block, String key, String path) {
        return this.registerBlock(block, key, this.defaultItemBlock(block), path);
    }

    public <T extends Block> T registerBlock(T block, String key) {
        return this.registerBlock(block, key, this.defaultItemBlock(block));
    }

    @Nonnull
    private <T extends Block> ItemBlock defaultItemBlock(T block) {
        if (block instanceof BlockMetaSubtypes) {
            return new ItemBlockMetaSubtypes((BlockMetaSubtypes)block);
        }
        return new ItemBlock(block);
    }

    public <T extends Block> T registerBlock(T block, String key, ItemBlock itemBlock) {
        this.blocks.add(block);
        block.func_149663_c(this.modId + "." + key);
        this.validateRegistryName(key);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)block, name);
        ForgeRegistries.BLOCKS.register(block);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)itemBlock, name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        if (block instanceof ITEBlock) {
            Class<? extends TileEntity> clazz = ((ITEBlock)block).getTileEntityClass();
            this.registerTileEntity(clazz, key);
        }
        if (block instanceof IAddRecipe) {
            this.recipeAdders.add((IAddRecipe)block);
        }
        if (MCUtil.isClient() && block instanceof IColorBlock) {
            this.coloredBlocks.add(block);
        }
        if (this.creativeTab != null) {
            block.func_149647_a(this.creativeTab);
        }
        return block;
    }

    public <T extends Block> T registerBlock(T block, String key, ItemBlock itemBlock, String path) {
        this.blocks.add(block);
        block.func_149663_c(this.modId + "." + key);
        this.validateRegistryName(key);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)block, name);
        ForgeRegistries.BLOCKS.register(block);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)itemBlock, name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        if (block instanceof ITEBlock) {
            Class<? extends TileEntity> clazz = ((ITEBlock)block).getTileEntityClass();
            this.registerTileEntity(clazz, key);
        }
        if (block instanceof IAddRecipe) {
            this.recipeAdders.add((IAddRecipe)block);
        }
        if (MCUtil.isClient() && block instanceof IColorBlock) {
            this.coloredBlocks.add(block);
        }
        if (this.creativeTab != null) {
            block.func_149647_a(this.creativeTab);
        }
        return block;
    }

    public <T extends Item> T registerItem(T item, String key) {
        this.items.add(item);
        item.func_77655_b(this.modId + "." + key.toLowerCase());
        this.validateRegistryName(key);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)item, name);
        ForgeRegistries.ITEMS.register(item);
        if (item instanceof IAddRecipe) {
            this.recipeAdders.add((IAddRecipe)item);
        }
        if (MCUtil.isClient() && item instanceof IColorItem) {
            this.coloredItems.add(item);
        }
        if (this.defaultCreativeTab != null) {
            item.func_77637_a(this.defaultCreativeTab);
        }
        return item;
    }

    public void registerEnchantment(Enchantment enchantment, String key) {
        this.validateRegistryName(key);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)enchantment, name);
        enchantment.func_77322_b(name.func_110624_b() + "." + name.func_110623_a());
        ForgeRegistries.ENCHANTMENTS.register((IForgeRegistryEntry)enchantment);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, 64, 20, true);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ResourceLocation resource = new ResourceLocation(this.modId, key);
        EntityRegistry.registerModEntity((ResourceLocation)resource, entityClass, (String)key, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        this.registerEntity(entityClass, key, ++this.lastEntityId, this.mod, trackingRange, updateFrequency, sendsVelocityUpdates, eggPrimary, eggSecondary);
    }

    public void registerEntity(Class<? extends Entity> entityClass, String key, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        ResourceLocation resource = new ResourceLocation(this.modId, key);
        EntityRegistry.registerModEntity((ResourceLocation)resource, entityClass, (String)key, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, IRenderFactory<T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    public void registerPotion(Potion potion, String key) {
        if (potion.func_76393_a().isEmpty()) {
            potion.func_76390_b("effect." + this.modId + "." + key);
        }
        this.validateRegistryName(key);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)potion, name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
    }

    public void registerSoundEvent(SoundEvent sound, String key) {
        this.validateRegistryName(key);
        ResourceLocation name = new ResourceLocation(this.modId, key);
        this.safeSetRegistryName((IForgeRegistryEntry<?>)sound, name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
    }

    public void registerLootCondition(LootCondition.Serializer<? extends LootCondition> serializer) {
        LootConditionManager.func_186639_a(serializer);
    }

    public void registerLootEntityProperty(EntityProperty.Serializer<? extends EntityProperty> serializer) {
        EntityPropertyManager.func_186644_a(serializer);
    }

    public void registerLootFunction(LootFunction.Serializer<? extends LootFunction> serializer) {
        LootFunctionManager.func_186582_a(serializer);
    }

    public void registerLootTable(String name) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(this.modId, name));
    }

    private void safeSetRegistryName(IForgeRegistryEntry<?> entry, ResourceLocation name) {
        if (entry.getRegistryName() == null) {
            entry.setRegistryName(name);
        } else {
            this.logger.warn("Registry name for {} has already been set. Was trying to set it to {}.", entry.getRegistryName(), name);
        }
    }

    private void validateRegistryName(String name) {
        if (PATTERN_REGISTRY_NAME.matcher(name).matches()) {
            this.logger.warn("Invalid name for object: {}", name);
        }
    }

    public <T extends ICriterionInstance> ICriterionTrigger<T> registerAdvancementTrigger(ICriterionTrigger<T> trigger) {
        CriteriaTriggers.func_192118_a(trigger);
        return trigger;
    }

    public void registerTileEntity(Class<? extends TileEntity> tileClass, String key) {
        GameRegistry.registerTileEntity(tileClass, (ResourceLocation)new ResourceLocation(this.modId, key));
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends TileEntity> void registerTileEntitySpecialRenderer(Class<T> tileClass, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void setModel(Block block, int meta, String modelPath) {
        this.setModel(Item.func_150898_a((Block)block), meta, modelPath, "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void setModel(Block block, int meta, String modelPath, String variant) {
        this.setModel(Item.func_150898_a((Block)block), meta, modelPath, variant);
    }

    @SideOnly(value=Side.CLIENT)
    public void setModel(Item item, int meta, String modelPath) {
        this.setModel(item, meta, modelPath, "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void setModel(Item item, int meta, String modelPath, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(this.resourcePrefix + modelPath, variant));
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (this.preInitDone) {
            this.logger.warn("preInit called more than once!");
            return;
        }
        this.verifyOrFindModObject();
        this.preInitDone = true;
    }

    private void verifyOrFindModObject() {
        if (this.mod == null) {
            this.logger.warn("Mod {} did not manually set its mod object! This is bad and may cause crashes.", this.modId);
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(this.modId);
            if (container != null) {
                this.mod = container.getMod();
                this.logger.warn("Automatically acquired mod object for {}", this.modId);
            } else {
                this.logger.warn("Could not find mod object. The mod ID is likely incorrect.");
            }
        }
    }

    public void init(FMLInitializationEvent event) {
        if (this.initDone) {
            this.logger.warn("init called more than once!");
            return;
        }
        this.initDone = true;
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (this.postInitDone) {
            this.logger.warn("postInit called more than once!");
            return;
        }
        int oldRecipeRegisterCount = this.recipes.getOldRecipeRegisterCount();
        if (oldRecipeRegisterCount > 0) {
            long l = ForgeRegistries.RECIPES.getKeys().stream().map(ResourceLocation::func_110624_b).filter(s -> s.equals(this.modId)).count();
        }
        this.postInitDone = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPreInit(FMLPreInitializationEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientInit(FMLInitializationEvent event) {
        for (Block block : this.blocks) {
            ITEBlock tileBlock;
            TileEntitySpecialRenderer<?> tesr;
            if (!(block instanceof ITEBlock) || (tesr = (tileBlock = (ITEBlock)block).getTileRenderer()) == null) continue;
            ClientRegistry.bindTileEntitySpecialRenderer(tileBlock.getTileEntityClass(), tesr);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPostInit(FMLPostInitializationEvent event) {
    }

    private void addRecipes() {
        this.recipeAdders.forEach(obj -> obj.addRecipes(this.recipes));
    }

    private void addOreDictEntries() {
        this.recipeAdders.forEach(IAddRecipe::addOreDict);
    }

    @SideOnly(value=Side.CLIENT)
    private void registerModels() {
        ModelResourceLocation model;
        ResourceLocation registryName;
        for (Block block : this.blocks) {
            if (block instanceof ICustomModel) {
                ((ICustomModel)block).registerModels();
                continue;
            }
            registryName = Objects.requireNonNull(block.getRegistryName());
            model = new ModelResourceLocation(registryName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)model);
        }
        for (Item item : this.items) {
            if (item instanceof ICustomMesh) {
                ICustomMesh customMesh = (ICustomMesh)item;
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])customMesh.getVariants());
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)customMesh.getCustomMesh());
                continue;
            }
            if (item instanceof ICustomModel) {
                ((ICustomModel)item).registerModels();
                continue;
            }
            registryName = Objects.requireNonNull(item.getRegistryName());
            model = new ModelResourceLocation(registryName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)model);
        }
    }

    public CreativeTabs getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public void setDefaultCreativeTab(CreativeTabs defaultCreativeTab) {
        this.defaultCreativeTab = defaultCreativeTab;
    }

    public CreativeTabs getCreativeTabs() {
        return this.creativeTab;
    }

    public void setCreativeTab(CreativeTabs creativeTabs) {
        this.creativeTab = creativeTabs;
    }

    public static class EventHandler {
        private final StellarRegistry ModRegistry;

        public EventHandler(StellarRegistry ModRegistry) {
            this.ModRegistry = ModRegistry;
        }

        private void runRegistrationHandlerIfPresent(Class<? extends IForgeRegistryEntry<?>> registryClass) {
            if (this.ModRegistry.registrationHandlers.containsKey(registryClass)) {
                ((Consumer)this.ModRegistry.registrationHandlers.get(registryClass)).accept(this.ModRegistry);
            }
        }

        @SubscribeEvent
        public void registerBlocks(RegistryEvent.Register<Block> event) {
            this.runRegistrationHandlerIfPresent(Block.class);
        }

        @SubscribeEvent
        public void registerItems(RegistryEvent.Register<Item> event) {
            this.runRegistrationHandlerIfPresent(Item.class);
            this.ModRegistry.addOreDictEntries();
        }

        @SubscribeEvent
        public void registerPotions(RegistryEvent.Register<Potion> event) {
            this.runRegistrationHandlerIfPresent(Potion.class);
        }

        @SubscribeEvent
        public void registerBiomes(RegistryEvent.Register<Biome> event) {
            this.runRegistrationHandlerIfPresent(Biome.class);
        }

        @SubscribeEvent
        public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            this.runRegistrationHandlerIfPresent(SoundEvent.class);
        }

        @SubscribeEvent
        public void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
            this.runRegistrationHandlerIfPresent(PotionType.class);
        }

        @SubscribeEvent
        public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
            this.runRegistrationHandlerIfPresent(Enchantment.class);
        }

        @SubscribeEvent
        public void registerVillagerProfessions(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
            this.runRegistrationHandlerIfPresent(VillagerRegistry.VillagerProfession.class);
        }

        @SubscribeEvent
        public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            this.runRegistrationHandlerIfPresent(EntityEntry.class);
        }

        @SubscribeEvent
        public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            this.runRegistrationHandlerIfPresent(IRecipe.class);
            this.ModRegistry.addRecipes();
        }

        @SubscribeEvent
        public void registerModels(ModelRegistryEvent event) {
            this.ModRegistry.registerModels();
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void registerBlockColors(ColorHandlerEvent.Block event) {
            BlockColors blockColors = event.getBlockColors();
            for (Block block : this.ModRegistry.coloredBlocks) {
                blockColors.func_186722_a(((IColorBlock)block).getColorHandler(), new Block[]{block});
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void registerItemColors(ColorHandlerEvent.Item event) {
            ItemColors itemColors = event.getItemColors();
            for (Block block : this.ModRegistry.coloredBlocks) {
                itemColors.func_186730_a(((IColorBlock)block).getItemColorHandler(), new Item[]{Item.func_150898_a((Block)block)});
            }
            for (Item item : this.ModRegistry.coloredItems) {
                itemColors.func_186730_a(((IColorItem)item).getColorHandler(), new Item[]{item});
            }
        }
    }
}

