/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class StackList
extends ArrayList<ItemStack> {
    private static final long serialVersionUID = 6598290132403044449L;

    private StackList() {
    }

    public static StackList of(ItemStack ... stacks) {
        StackList newList = new StackList();
        Collections.addAll(newList, stacks);
        return newList;
    }

    public static StackList fromInventory(IInventory inventory) {
        StackList newList = new StackList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            newList.add(inventory.func_70301_a(i));
        }
        return newList;
    }

    public static StackList fromNBT(NBTTagList tagList) {
        StackList newList = new StackList();
        for (NBTBase nbt : tagList) {
            if (!(nbt instanceof NBTTagCompound)) continue;
            newList.add(new ItemStack((NBTTagCompound)nbt));
        }
        return newList;
    }

    public ItemStack firstOfType(Class<?> itemClass) {
        return this.firstMatch(StackList.itemClassMatcher(itemClass));
    }

    public ItemStack firstMatch(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).findFirst().orElse(ItemStack.field_190927_a);
    }

    public ItemStack uniqueOfType(Class<?> itemClass) {
        return this.uniqueMatch(StackList.itemClassMatcher(itemClass));
    }

    public ItemStack uniqueMatch(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.size() == 1 ? (ItemStack)list.get(0) : ItemStack.field_190927_a));
    }

    public Collection<ItemStack> allOfType(Class<?> itemClass) {
        return this.allMatches(StackList.itemClassMatcher(itemClass));
    }

    public Collection<ItemStack> allMatches(Predicate<ItemStack> predicate) {
        return this.stream().filter(predicate).collect(Collectors.toList());
    }

    public int countOfType(Class<?> itemClass) {
        return this.countOfMatches(StackList.itemClassMatcher(itemClass));
    }

    public int countOfMatches(Predicate<ItemStack> predicate) {
        return (int)this.stream().filter(predicate).count();
    }

    private static Predicate<ItemStack> itemClassMatcher(Class<?> itemClass) {
        return stack -> itemClass.isInstance(stack.func_77973_b());
    }

    @Override
    public boolean add(ItemStack itemStack) {
        return !itemStack.func_190926_b() && super.add(itemStack);
    }

    @Override
    public boolean addAll(Collection<? extends ItemStack> c) {
        boolean added = false;
        for (ItemStack itemStack : c) {
            if (itemStack.func_190926_b()) continue;
            added |= super.add(itemStack);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends ItemStack> c) {
        boolean added = false;
        for (ItemStack itemStack : c) {
            if (itemStack.func_190926_b()) continue;
            super.add(index, itemStack);
            added = true;
        }
        return added;
    }

    @Override
    public void add(int index, ItemStack element) {
        if (!element.func_190926_b()) {
            super.add(index, element);
        }
    }
}

