/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import com.google.common.base.Function;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.internal.client.ExoModelLoader;
import net.rom.exoplanets.internal.wrapper.ModelTransWrapper;

public final class MCUtil {
    private static MinecraftServer serverCached;

    private MCUtil() {
        throw new IllegalAccessError("Util Class");
    }

    public static Random getRandom(BlockPos pos) {
        long blockSeed = ((pos.func_177956_o() << 28) + pos.func_177958_n() + 30000000 << 28) + pos.func_177952_p() + 30000000;
        return new Random(blockSeed);
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getSide().isServer();
    }

    public static boolean isDeobfuscated() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static MinecraftServer getServer() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return serverCached;
        }
        return server;
    }

    public static Minecraft getClient() {
        return FMLClientHandler.instance().getClient();
    }

    public static void replaceModel(String modid, ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransWrapper> clazz, IModelState parentState, String ... variants) {
        OBJModel model;
        try {
            model = (OBJModel)ExoModelLoader.instance.loadModel(new ResourceLocation(modid, objLoc));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        IBakedModel newModelBase = model.bake((IModelState)new OBJModel.OBJState(visibleGroups, false, parentState), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
        IBakedModel newModelAlt = null;
        if (variants.length == 0) {
            variants = new String[]{"inventory"};
        } else if (variants.length > 1 || !variants[0].equals("inventory")) {
            newModelAlt = model.bake((IModelState)new OBJModel.OBJState(visibleGroups, false, (IModelState)TRSRTransformation.identity()), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
        }
        for (String variant : variants) {
            IBakedModel newModel;
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(modid + ":" + resLoc, variant);
            IBakedModel object = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelResourceLocation);
            if (object == null) continue;
            IBakedModel iBakedModel = newModel = variant.equals("inventory") ? newModelBase : newModelAlt;
            if (clazz != null) {
                try {
                    newModel = clazz.getConstructor(IBakedModel.class).newInstance(newModel);
                }
                catch (Exception e) {
                    ExoplanetsMod.logger.bigFatal(true, "ItemModel constructor problem for  %s", modelResourceLocation);
                    e.printStackTrace();
                }
            }
            event.getModelRegistry().func_82595_a((Object)modelResourceLocation, (Object)newModel);
        }
    }
}

