/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import java.util.Locale;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.WorldProvider;
import net.rom.api.space.ExoPlanet;
import net.rom.api.space.ExoSystem;
import net.rom.exoplanets.astronomy.trappist1.c.WorldProviderTrappist1C;
import net.rom.exoplanets.astronomy.trappist1.e.WorldProviderTrappist1E;
import net.rom.exoplanets.astronomy.yzceti.b.WorldProviderYzCetiB;
import net.rom.exoplanets.astronomy.yzceti.c.WorldProviderYzCetiC;
import net.rom.exoplanets.astronomy.yzceti.d.WorldProviderYzCetiD;
import net.rom.exoplanets.conf.ConfigPlanets;
import net.rom.exoplanets.init.SolarSystems;

public enum Exoplanets implements IStringSerializable
{
    TRAPPIST1B("Trappist1B", SolarSystems.trappist1, ConfigPlanets.id_trap_b, 0.3f, 0.85, 1.086, null),
    TRAPPIST1C("Trappist1C", SolarSystems.trappist1, ConfigPlanets.id_trap_c, 0.4f, 1.38, 1.056, WorldProviderTrappist1C.class),
    TRAPPIST1D("Trappist1D", SolarSystems.trappist1, ConfigPlanets.id_trap_d, 0.6f, 0.41, 0.772, null),
    TRAPPIST1E("Trappist1E", SolarSystems.trappist1, ConfigPlanets.id_trap_e, 0.8f, 0.62, 0.918, WorldProviderTrappist1E.class),
    TRAPPIST1F("Trappist1F", SolarSystems.trappist1, ConfigPlanets.id_trap_f, 1.0f, 0.68, 1.045, null),
    TRAPPIST1G("Trappist1G", SolarSystems.trappist1, ConfigPlanets.id_trap_g, 1.2f, 1.34, 1.127, null),
    TRAPPIST1H("Trappist1H", SolarSystems.trappist1, ConfigPlanets.id_trap_h, 1.6f, 0.331, 0.752, null),
    YZCETIB("YzCetiB", SolarSystems.yzCeti, ConfigPlanets.id_yz_b, 0.3f, 0.75, 0.93, WorldProviderYzCetiB.class),
    YZCETIC("YzCetiC", SolarSystems.yzCeti, ConfigPlanets.id_yz_c, 0.4f, 0.98, 1.0, WorldProviderYzCetiC.class),
    YZCETID("YzCetiD", SolarSystems.yzCeti, ConfigPlanets.id_yz_d, 0.59f, 1.14, 1.05, WorldProviderYzCetiD.class),
    WOLF1061B("Wolf1061B", SolarSystems.wolf1061, ConfigPlanets.id_wolf_b, 0.3f, 1.91, 1.21, null),
    WOLF1061C("Wolf1061C", SolarSystems.wolf1061, ConfigPlanets.id_wolf_c, 0.6f, 3.41, 1.66, null),
    WOLF1061D("Wolf1061D", SolarSystems.wolf1061, ConfigPlanets.id_wolf_d, 2.5f, 7.7, Exoplanets.r(0.24), null),
    KEPLER1649B("Kepler1649B", SolarSystems.kepler1649, ConfigPlanets.id_kepler_b, 0.4f, 1.03, 1.017, null),
    KEPLER1649C("Kepler1649C", SolarSystems.kepler1649, ConfigPlanets.id_kepler_c, 0.8f, 1.2, 1.06, null);

    private final String name;
    private final ExoSystem parentSystem;
    private final int dimensionId;
    private final float orbitalAu;
    private final double earthMass;
    private final double earthRadius;
    private final Class<? extends WorldProvider> providerClass;

    private Exoplanets(String name, ExoSystem parentSystem, int dimensionId, float orbitalAu, double earthMass, double earthRadius, Class<? extends WorldProvider> providerClass) {
        this.name = name;
        this.parentSystem = parentSystem;
        this.dimensionId = dimensionId;
        this.orbitalAu = orbitalAu;
        this.earthMass = earthMass;
        this.earthRadius = earthRadius;
        this.providerClass = providerClass;
    }

    public ExoPlanet get() {
        ExoPlanet exo = new ExoPlanet(this.name);
        exo.setParentSolarSystem(this.parentSystem);
        exo.setDistanceFromCenter(this.orbitalAu);
        exo.setOrbitPeriod(this.orbitalAu);
        return exo;
    }

    public ExoPlanet getExoPlanet() {
        ExoPlanet exo = new ExoPlanet(this.name);
        exo.setPlanetSystem(this.parentSystem);
        exo.setPlanetMass(this.earthMass);
        exo.setPlanetRadius(this.earthRadius);
        exo.setDimensionInfo(this.dimensionId, this.providerClass);
        exo.setDistanceFromCenter(this.orbitalAu);
        exo.setOrbitPeriod(this.orbitalAu);
        return exo;
    }

    public String func_176610_l() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public Class<? extends WorldProvider> getProviderClass() {
        return this.providerClass;
    }

    public String getPlanetName() {
        return this.name;
    }

    public ExoSystem getParentSystem() {
        return this.parentSystem;
    }

    public float getOrbitalAu() {
        return this.orbitalAu;
    }

    public double getEarthMass() {
        return this.earthMass;
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public static double r(double radius) {
        return 11.209 * radius;
    }
}

