/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import java.util.Optional;
import java.util.function.Function;

public final class EnumUtils {
    private EnumUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T extends Enum<T>> Optional<T> fromString(Class<T> enumClass, String value) {
        return EnumUtils.fromString(enumClass, value, true);
    }

    public static <T extends Enum<T>> Optional<T> fromString(Class<T> enumClass, String value, boolean ignoreCase) {
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            if ((!ignoreCase || !t.name().equalsIgnoreCase(value)) && !t.name().equals(value)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> Optional<T> fromIndex(Class<T> enumClass, int value, Function<T, Integer> getter) {
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            if (getter.apply(t) != value) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> Optional<T> fromOrdinal(Class<T> enumClass, int value) {
        if (value < 0 || value >= ((Enum[])enumClass.getEnumConstants()).length) {
            return Optional.empty();
        }
        return Optional.of(((Enum[])enumClass.getEnumConstants())[value]);
    }
}

