/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import net.rom.exoplanets.internal.enums.EnumPlanetType;
import net.rom.exoplanets.internal.enums.EnumTPHClass;

public class Calculations {
    public static final long yearFactor = 8640000L;
    public static final long monthFactor = 192000L;
    public static final String nameSeparator = "\\";
    public static final double moonDistanceFactor = 1.5E-4;
    public static final double planetDistanceFactor = 1.0;
    public static final double systemDistanceFactor = 0.011504250961025843;
    public static final float maxTemperature = 5.0f;
    public static final float maxSolarLevel = 10.0f;
    public static final double AUlength = 1.495978707E11;
    public static final double maxSpeed = 2.99792458E8;

    public static float getThermalLevel(CelestialBody body) {
        if (body instanceof Star) {
            return 5.0f;
        }
        body = Calculations.getParentPlanet(body);
        float dist = body.getRelativeDistanceFromCenter().unScaledDistance;
        float temperature = -4.0f * dist + 4.0f;
        if (temperature < -5.0f) {
            temperature = -5.0f;
        } else if (temperature > 5.0f) {
            temperature = 5.0f;
        }
        return temperature;
    }

    public static CelestialBody getParentPlanet(CelestialBody body) {
        if (body == null) {
            return null;
        }
        if (body instanceof Moon) {
            return ((Moon)body).getParentPlanet();
        }
        if (body instanceof IChildBody) {
            return ((IChildBody)body).getParentPlanet();
        }
        return body;
    }

    public static double schwartzchildRadius(double M) {
        double r = 1.334816E-10 * M * 1.9891E30 / 8.987551787368176E16;
        return r / 6.957E8;
    }

    public static double getLuminosityFromMassLuminosityRelation(double mass) {
        if (mass < 0.43) {
            return 0.23 * Math.pow(mass, 2.3);
        }
        if (mass < 2.0) {
            return Math.pow(mass, 4.0);
        }
        if (mass > 20.0) {
            return 1.5 * Math.pow(20.0, 3.5) * Math.pow(mass / 20.0, 2.0);
        }
        return 1.5 * Math.pow(mass, 3.5);
    }

    public static double getStarRadius(double luminosity, double temperature) {
        return Math.sqrt(luminosity * 3.846E26 / (7.125593324143197E-7 * Math.pow(temperature, 4.0))) / 6.957E8;
    }

    public static double getStarLuminosity(double radius, double temperature) {
        double luminosity = Math.pow(radius * 695700.0 * 1000.0, 2.0) * (7.125593324143197E-7 * Math.pow(temperature, 4.0));
        return luminosity / 3.846E26;
    }

    public static double getStarSurfaceGravity(double mass, double radius) {
        double g = 6.67408E-11 * mass * 1.9891E30 / Math.pow(radius * 695700.0 * 1000.0, 2.0);
        return g;
    }

    public static double getPlanetSurfaceGravity(double mass, double radius) {
        double g = 6.67408E-11 * (mass * 6378.1366) / Math.pow(radius * 6378.1366, 2.0);
        return g;
    }

    public static boolean between(double i, double minValueInclusive, double maxValueInclusive) {
        return i >= minValueInclusive && i <= maxValueInclusive;
    }

    public static boolean isMoreThan(double i, double max) {
        return i >= max;
    }

    public static boolean isLessThan(double i, double min) {
        return i <= min;
    }

    public static EnumTPHClass getTPHFromTemp(double temp) {
        if (Calculations.between(temp, -100.0, -50.0)) {
            return EnumTPHClass.HP;
        }
        if (Calculations.between(temp, -49.0, 0.0)) {
            return EnumTPHClass.P;
        }
        if (Calculations.between(temp, 1.0, 49.0)) {
            return EnumTPHClass.M;
        }
        if (Calculations.between(temp, 50.0, 100.0)) {
            return EnumTPHClass.T;
        }
        if (Calculations.between(temp, 101.0, 150.0)) {
            return EnumTPHClass.HT;
        }
        if (Calculations.isLessThan(temp, -100.0)) {
            return EnumTPHClass.HP;
        }
        return EnumTPHClass.HT;
    }

    public static EnumPlanetType getPlanetType(double mass, double radius) {
        if (Calculations.datasetAsteroidan(mass, radius)) {
            return EnumPlanetType.ASTEROIDAN;
        }
        if (Calculations.datasetMercurian(mass, radius)) {
            return EnumPlanetType.MERCURIAN;
        }
        if (Calculations.datasetSubterran(mass, radius)) {
            return EnumPlanetType.SUBTERRAN;
        }
        if (Calculations.datasetTerran(mass, radius)) {
            return EnumPlanetType.TERRAN;
        }
        if (Calculations.datasetSuperterran(mass, radius)) {
            return EnumPlanetType.SUPERTERRAN;
        }
        if (Calculations.datasetNeptunian(mass, radius)) {
            return EnumPlanetType.NEPTUNIAN;
        }
        if (Calculations.datasetJovian(mass, radius)) {
            return EnumPlanetType.JOVIAN;
        }
        return null;
    }

    private static boolean datasetAsteroidan(double mass, double radius) {
        return Calculations.between(mass, 0.0, 1.0E-5) && Calculations.between(radius, 0.0, 0.03);
    }

    private static boolean datasetMercurian(double mass, double radius) {
        return Calculations.between(mass, 1.0E-5, 0.1) && Calculations.between(radius, 0.03, 0.7);
    }

    private static boolean datasetSubterran(double mass, double radius) {
        return Calculations.between(mass, 0.1, 0.5) && Calculations.between(radius, 0.5, 1.2);
    }

    private static boolean datasetTerran(double mass, double radius) {
        return Calculations.between(mass, 0.5, 2.0) && Calculations.between(radius, 0.8, 1.9);
    }

    private static boolean datasetSuperterran(double mass, double radius) {
        return Calculations.between(mass, 2.0, 10.0) && Calculations.between(radius, 1.3, 3.3);
    }

    private static boolean datasetNeptunian(double mass, double radius) {
        return Calculations.between(mass, 10.0, 50.0) && Calculations.between(radius, 2.1, 5.7);
    }

    private static boolean datasetJovian(double mass, double radius) {
        return Calculations.between(mass, 50.0, 5000.0) && Calculations.between(radius, 3.5, 27.0);
    }
}

