/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public final class BlockUtil {
    public static final String GROUP_RESLOC = "resloc";
    public static final String GROUP_PROPERTIES = "props";
    public static final String BLOCKSTATE_PATTERN = "^(?<resloc>[a-z0-9_]*:[a-z0-9_]+)(?:(?:\\[)(?<props>[a-z0-9_]+=[a-z0-9_]+(?:,[a-z0-9_]+=[a-z0-9_]+)*)?(?:\\]))?.*$";
    public static final Pattern BLOCKSTATE_MATCHER = Pattern.compile("^(?<resloc>[a-z0-9_]*:[a-z0-9_]+)(?:(?:\\[)(?<props>[a-z0-9_]+=[a-z0-9_]+(?:,[a-z0-9_]+=[a-z0-9_]+)*)?(?:\\]))?.*$");

    private BlockUtil() {
    }

    public static IBlockState getStateSand(BlockSand.EnumType variant) {
        switch (variant) {
            case SAND: {
                return Blocks.field_150354_m.func_176223_P();
            }
            case RED_SAND: {
                return Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
            }
        }
        return Blocks.field_150354_m.func_176223_P();
    }

    public static IBlockState getStateDirt(BlockDirt.DirtType variant) {
        switch (variant) {
            case DIRT: {
                return Blocks.field_150346_d.func_176223_P();
            }
            case COARSE_DIRT: {
                return Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
            }
            case PODZOL: {
                return Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
            }
        }
        return Blocks.field_150346_d.func_176223_P();
    }

    public static IBlockState getStateDirt(Block block) {
        return block.func_176223_P();
    }

    @Nullable
    public static Block getBlock(@Nullable String resourceLocation) {
        return !StringUtils.isEmpty((CharSequence)resourceLocation) ? BlockUtil.getBlock(new ResourceLocation(resourceLocation)) : null;
    }

    @Nullable
    public static Block getBlock(@Nullable ResourceLocation resourceLocation) {
        return resourceLocation != null && Block.field_149771_c.func_148741_d((Object)resourceLocation) ? (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation) : null;
    }

    public static Block getBlock(@Nullable String resourceLocation, Block fallback) {
        return !StringUtils.isEmpty((CharSequence)resourceLocation) ? BlockUtil.getBlock(new ResourceLocation(resourceLocation), fallback) : fallback;
    }

    public static Block getBlock(@Nullable ResourceLocation resourceLocation, Block fallback) {
        Block block = BlockUtil.getBlock(resourceLocation);
        return block != null ? block : fallback;
    }

    public static IBlockState getPossibleState(Block block, String propertyName, String valueName, IBlockState fallback) {
        if (StringUtils.isEmpty((CharSequence)propertyName) || StringUtils.isEmpty((CharSequence)valueName)) {
            return fallback;
        }
        IBlockState bs = BlockUtil.getPossibleState(block, propertyName, valueName);
        return bs != null ? bs : fallback;
    }

    @Nullable
    public static IBlockState getPossibleState(Block block, String propertyName, String valueName) {
        if (StringUtils.isEmpty((CharSequence)propertyName) || StringUtils.isEmpty((CharSequence)valueName)) {
            return null;
        }
        IProperty property = block.func_176194_O().func_185920_a(propertyName);
        return property != null ? BlockUtil.getPossibleState(block.func_176223_P(), property, valueName) : null;
    }

    @Nullable
    public static IBlockState getPossibleState(IBlockState blockState, String propertyName, String valueName) {
        if (StringUtils.isEmpty((CharSequence)propertyName) || StringUtils.isEmpty((CharSequence)valueName)) {
            return null;
        }
        IProperty property = blockState.func_177230_c().func_176194_O().func_185920_a(propertyName);
        return property != null ? BlockUtil.getPossibleState(blockState, property, valueName) : null;
    }

    public static <T extends Comparable<T>> IBlockState getPossibleState(IBlockState blockstate, IProperty<T> propname, String valueName) {
        if (StringUtils.isEmpty((CharSequence)valueName)) {
            return blockstate;
        }
        Optional value = propname.func_185929_b(valueName);
        return value.isPresent() ? blockstate.func_177226_a(propname, (Comparable)value.get()) : blockstate;
    }

    public static boolean isBlockAir(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isBlockAir(Block block) {
        return block == Blocks.field_150350_a;
    }

    public static boolean isMaterialAir(IBlockState blockState) {
        return blockState.func_185904_a() == Material.field_151579_a;
    }

    public static boolean isMaterialAir(Block block) {
        return block.func_176223_P().func_185904_a() == Material.field_151579_a;
    }

    public static boolean isMaterialAir(Material material) {
        return material == Material.field_151579_a;
    }

    public static boolean isBlock(World world, BlockPos origin, Block block) {
        return world.func_180495_p(origin).func_177230_c() == block;
    }

    public static boolean isBlockOneOf(World world, BlockPos origin, Block ... validBlocks) {
        return BlockUtil.isBlockOneOf(world, origin, Collections.unmodifiableCollection(Arrays.asList(validBlocks)));
    }

    public static boolean isBlockOneOf(World world, BlockPos origin, Collection<Block> validBlocks) {
        Block checkBlock = world.func_180495_p(origin).func_177230_c();
        return validBlocks.isEmpty() ? BlockUtil.isBlockAir(checkBlock) : validBlocks.contains(checkBlock);
    }

    public static boolean isReplaceable(World world, BlockPos origin) {
        return world.func_180495_p(origin).func_185904_a().func_76222_j();
    }

    public static boolean checkAreaBlocks(MatchType matchType, World world, BlockPos origin, int checkRadius, Block ... validBlocks) {
        return BlockUtil.checkAreaBlocks(matchType, world, origin, checkRadius, Collections.unmodifiableCollection(Arrays.asList(validBlocks)));
    }

    public static boolean checkAreaBlocks(MatchType matchType, World world, BlockPos origin, int checkRadius, Collection<Block> validBlocks) {
        int ox = origin.func_177958_n();
        int oy = origin.func_177956_o();
        int oz = origin.func_177952_p();
        boolean ignoreReplaceable = matchType == MatchType.ALL_IGNORE_REPLACEABLE;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        switch (matchType) {
            case ALL_IGNORE_REPLACEABLE: 
            case ALL: {
                int i;
                for (i = 1; i <= checkRadius; ++i) {
                    IBlockState bs;
                    int x = ox + i;
                    int z = oz + i;
                    while (x > ox - i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(--x, oy, z));
                        if (!(ignoreReplaceable && !bs.func_185904_a().func_76222_j() || validBlocks.isEmpty() ? !BlockUtil.isBlockAir(bs) : !validBlocks.contains(bs.func_177230_c()))) continue;
                        return false;
                    }
                    while (z > oz - i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(x, oy, --z));
                        if (!(ignoreReplaceable && !bs.func_185904_a().func_76222_j() || validBlocks.isEmpty() ? !BlockUtil.isBlockAir(bs) : !validBlocks.contains(bs.func_177230_c()))) continue;
                        return false;
                    }
                    while (x < ox + i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(++x, oy, z));
                        if (!(ignoreReplaceable && !bs.func_185904_a().func_76222_j() || validBlocks.isEmpty() ? !BlockUtil.isBlockAir(bs) : !validBlocks.contains(bs.func_177230_c()))) continue;
                        return false;
                    }
                    while (z < oz + i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(x, oy, ++z));
                        if (!(ignoreReplaceable && !bs.func_185904_a().func_76222_j() || validBlocks.isEmpty() ? !BlockUtil.isBlockAir(bs) : !validBlocks.contains(bs.func_177230_c()))) continue;
                        return false;
                    }
                }
                return true;
            }
            case ANY: {
                int i;
                while (i <= checkRadius) {
                    IBlockState bs;
                    int x = ox + i;
                    int z = oz + i;
                    while (x > ox - i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(--x, oy, z));
                        if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(bs) : validBlocks.contains(bs.func_177230_c()))) continue;
                        return true;
                    }
                    while (z > oz - i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(x, oy, --z));
                        if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(bs) : validBlocks.contains(bs.func_177230_c()))) continue;
                        return true;
                    }
                    while (x < ox + i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(++x, oy, z));
                        if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(bs) : validBlocks.contains(bs.func_177230_c()))) continue;
                        return true;
                    }
                    while (z < oz + i) {
                        bs = world.func_180495_p((BlockPos)mpos.func_181079_c(x, oy, ++z));
                        if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(bs) : validBlocks.contains(bs.func_177230_c()))) continue;
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case NONE: {
                int i;
                while (i <= checkRadius) {
                    int x = ox + i;
                    int z = oz + i;
                    while (x > ox - i) {
                        if (!validBlocks.contains(world.func_180495_p((BlockPos)mpos.func_181079_c(--x, oy, z)).func_177230_c())) continue;
                        return false;
                    }
                    while (z > oz - i) {
                        if (!validBlocks.contains(world.func_180495_p((BlockPos)mpos.func_181079_c(x, oy, --z)).func_177230_c())) continue;
                        return false;
                    }
                    while (x < ox + i) {
                        if (!validBlocks.contains(world.func_180495_p((BlockPos)mpos.func_181079_c(++x, oy, z)).func_177230_c())) continue;
                        return false;
                    }
                    while (z < oz + i) {
                        if (!validBlocks.contains(world.func_180495_p((BlockPos)mpos.func_181079_c(x, oy, ++z)).func_177230_c())) continue;
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean checkAdjacentBlocks(MatchType matchType, World world, BlockPos origin, Block ... validBlocks) {
        return BlockUtil.checkAdjacentBlocks(matchType, world, origin, Collections.unmodifiableCollection(Arrays.asList(validBlocks)));
    }

    public static boolean checkAdjacentBlocks(MatchType matchType, World world, BlockPos origin, Collection<Block> validBlocks) {
        boolean ignoreReplaceable = matchType == MatchType.ALL_IGNORE_REPLACEABLE;
        switch (matchType) {
            case ALL_IGNORE_REPLACEABLE: 
            case ALL: {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    IBlockState bs = world.func_180495_p(origin.func_177972_a(direction));
                    if (!(ignoreReplaceable && !bs.func_185904_a().func_76222_j() || validBlocks.isEmpty() ? !BlockUtil.isBlockAir(bs) : !validBlocks.contains(bs.func_177230_c()))) continue;
                    return false;
                }
                return true;
            }
            case ANY: {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    Block block = world.func_180495_p(origin.func_177972_a(direction)).func_177230_c();
                    if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(block) : !validBlocks.contains(block))) continue;
                    return true;
                }
                return false;
            }
            case NONE: {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    Block block = world.func_180495_p(origin.func_177972_a(direction)).func_177230_c();
                    if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(block) : !validBlocks.contains(block))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean checkVerticalBlocks(MatchType matchType, World world, BlockPos origin, int distance, Block ... validBlocks) {
        return BlockUtil.checkVerticalBlocks(matchType, world, origin, distance, Collections.unmodifiableCollection(Arrays.asList(validBlocks)));
    }

    public static boolean checkVerticalBlocks(MatchType matchType, World world, BlockPos origin, int distance, Collection<Block> validBlocks) {
        int ox = origin.func_177958_n();
        int oy = origin.func_177956_o();
        int oz = origin.func_177952_p();
        int dis = Math.abs(distance);
        boolean invert = distance < 0;
        boolean ignoreReplaceable = matchType == MatchType.ALL_IGNORE_REPLACEABLE;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        switch (matchType) {
            case ALL_IGNORE_REPLACEABLE: 
            case ALL: {
                for (int i = dis; i > 0; --i) {
                    IBlockState bs = world.func_180495_p((BlockPos)mpos.func_181079_c(ox, oy + (invert ? -i : i), oz));
                    if (!(ignoreReplaceable && !bs.func_185904_a().func_76222_j() || validBlocks.isEmpty() ? !BlockUtil.isBlockAir(bs) : !validBlocks.contains(bs.func_177230_c()))) continue;
                    return false;
                }
                return true;
            }
            case ANY: {
                for (int i = dis; i > 0; --i) {
                    Block block = world.func_180495_p((BlockPos)mpos.func_181079_c(ox, oy + (invert ? -i : i), oz)).func_177230_c();
                    if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(block) : validBlocks.contains(block))) continue;
                    return true;
                }
                return false;
            }
            case NONE: {
                for (int i = dis; i > 0; --i) {
                    Block block = world.func_180495_p((BlockPos)mpos.func_181079_c(ox, oy + (invert ? -i : i), oz)).func_177230_c();
                    if (!(validBlocks.isEmpty() ? BlockUtil.isBlockAir(block) : validBlocks.contains(block))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean checkVolumeBlocks(MatchType matchType, World world, BlockPos origin, int checkRadius, int checkHeight, Block ... validBlocks) {
        return BlockUtil.checkVolumeBlocks(matchType, world, origin, checkRadius, checkHeight, Collections.unmodifiableCollection(Arrays.asList(validBlocks)));
    }

    public static boolean checkVolumeBlocks(MatchType matchType, World world, BlockPos origin, int checkRadius, int checkHeight, Collection<Block> validBlocks) {
        int ox = origin.func_177958_n();
        int oy = origin.func_177956_o();
        int oz = origin.func_177952_p();
        int height = Math.abs(checkHeight);
        boolean invert = checkHeight < 0;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        if (!BlockUtil.checkVerticalBlocks(matchType, world, origin, checkHeight, validBlocks)) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (BlockUtil.checkAreaBlocks(matchType, world, (BlockPos)mpos.func_181079_c(ox, oy + (invert ? -i : i), oz), checkRadius, validBlocks)) continue;
            return false;
        }
        return true;
    }

    public static enum MatchType {
        ALL_IGNORE_REPLACEABLE,
        ALL,
        ANY,
        NONE;

    }

    public static enum EnumMaterial {
        AIR(Material.field_151579_a),
        ANVIL(Material.field_151574_g),
        BARRIER(Material.field_175972_I),
        CACTUS(Material.field_151570_A),
        CAKE(Material.field_151568_F),
        CARPET(Material.field_151593_r),
        CIRCUITS(Material.field_151594_q),
        CLAY(Material.field_151571_B),
        CLOTH(Material.field_151580_n),
        CORAL(Material.field_151589_v),
        CRAFTED_SNOW(Material.field_151596_z),
        DRAGON_EGG(Material.field_151566_D),
        FIRE(Material.field_151581_o),
        GLASS(Material.field_151592_s),
        GOURD(Material.field_151572_C),
        GRASS(Material.field_151577_b),
        GROUND(Material.field_151578_c),
        ICE(Material.field_151588_w),
        IRON(Material.field_151573_f),
        LAVA(Material.field_151587_i),
        LEAVES(Material.field_151584_j),
        PACKED_ICE(Material.field_151598_x),
        PISTON(Material.field_76233_E),
        PLANTS(Material.field_151585_k),
        PORTAL(Material.field_151567_E),
        REDSTONE_LIGHT(Material.field_151591_t),
        ROCK(Material.field_151576_e),
        SAND(Material.field_151595_p),
        SNOW(Material.field_151597_y),
        SPONGE(Material.field_151583_m),
        STRUCTURE_VOID(Material.field_189963_J),
        TNT(Material.field_151590_u),
        VINE(Material.field_151582_l),
        WATER(Material.field_151586_h),
        WEB(Material.field_151569_G),
        WOOD(Material.field_151575_d);

        private final Material material;

        private EnumMaterial(Material material) {
            this.material = material;
        }

        public static Collection<Material> getMaterials() {
            return Collections.unmodifiableCollection(Arrays.stream(EnumMaterial.values()).map(EnumMaterial::getMaterial).collect(Collectors.toSet()));
        }

        @Nullable
        public static Material getByName(String name) {
            return Arrays.stream(EnumMaterial.values()).filter(material -> material.name().equals(name.toUpperCase(Locale.ENGLISH))).findFirst().map(EnumMaterial::getMaterial).orElse(null);
        }

        @Nullable
        public static EnumMaterial getByMaterial(Material material) {
            return Arrays.stream(EnumMaterial.values()).filter(value -> value.getMaterial() == material).findFirst().orElse(null);
        }

        public static Collection<Material> getReplaceable() {
            return Collections.unmodifiableCollection(Arrays.stream(EnumMaterial.values()).filter(EnumMaterial::isReplaceable).map(EnumMaterial::getMaterial).collect(Collectors.toList()));
        }

        public Material getMaterial() {
            return this.material;
        }

        public boolean isReplaceable() {
            return this.material.func_76222_j();
        }
    }
}

