/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import java.math.BigDecimal;

public class AstronomicalConstants {
    public static double JD_MINUS_MJD = 2400000.5;
    public static final BigDecimal BIG_PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    public static final BigDecimal BIG_TWO_PI = new BigDecimal(AstronomicalConstants.returnStrig(BIG_PI));
    public static final double TWO_PI = Math.PI * 2;
    public static final float TWO_PI_F = (float)Math.PI * 2;
    public static final double TWO_PI_INVERSE = 0.15915494309189535;
    public static final double FOUR_PI = Math.PI * 4;
    public static final double PI_OVER_TWO = 1.5707963267948966;
    public static final double PI_OVER_FOUR = 0.7853981633974483;
    public static final double PI_OVER_SIX = 0.5235987755982988;
    public static final double DEGREES_PER_CIRCLE = 360.0;
    public static final double MINUTES_PER_DEGREE = 60.0;
    public static final double SECONDS_PER_DEGREE = 3600.0;
    public static final double ARCSEC_TO_RAD = 4.84813681109536E-6;
    public static final double RAD_TO_ARCSEC = 206264.80624709636;
    public static final double ARCSEC_TO_DEG = 2.777777777777778E-4;
    public static final double RAD_TO_HOUR = 3.8197186342054885;
    public static final double RAD_TO_DAY = 0.15915494309189535;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double JULIAN_DAYS_PER_CENTURY = 36525.0;
    public static final double JULIAN_DAYS_PER_MILLENIA = 365250.0;
    public static final double HOURS_PER_DAY = 24.0;
    public static final double DAYS_PER_HOUR = 0.041666666666666664;
    public static final double MINUTES_PER_HOUR = 60.0;
    public static final double SECONDS_PER_MINUTE = 60.0;
    public static final double SECONDS_PER_HOUR = 3600.0;
    public static final double SECONDS_PER_DAY = 86400.0;
    public static final double MILLISECONDS_PER_SECOND = 1000.0;
    public static final double MILLISECONDS_PER_HOUR = 3600000.0;
    public static final double J2000 = 2451545.0;
    public static final double J1991_25 = 2448349.0625;
    public static final double TROPICAL_YEAR = 365.242198781;
    public static final double B1950 = 2433282.42345905;
    public static final double B1900 = 2415020.31352;
    public static final double J1950 = 2433282.5;
    public static final double J2050 = 2469807.5;
    public static final double J1900 = 2415020.0;
    public static final double ROUND_UP = 0.5;
    public static final double AU = 1.49597870691E8;
    public static final double EARTH_RADIUS = 6378.1366;
    public static final double EARTH_MEAN_ORBIT_RATE = 0.01720209895;
    public static final double PARSEC = 3.0856775807E16;
    public static final double LIGHT_YEAR = 9.460536207068016E15;
    public static final double LIGHT_TIME_DAYS_PER_AU = 0.00577551833109;
    public static final double EARTH_FLATENNING = 298.25642;
    public static final double EARTH_MEAN_ROTATION_RATE = 7.292115E-5;
    public static final double SPEED_OF_LIGHT = 2.99792458E8;
    public static final double SUN_GRAVITATIONAL_CONSTANT = 1.32712440017987E20;
    public static final double SIDEREAL_DAY_LENGTH = 1.0027378119113546;
    public static final double PLANCK_CONSTANT = 6.62607004E-34;
    public static final double ERGIO_TO_JULE = 1.0E-7;
    public static final double ERG_S_CM2_HZ_TO_JY = 1.0E23;
    public static final double JY_TO_W_HZ_M2 = 1.0E-26;
    public static final double BOLTZMANN_CONSTANT = 1.38064852E-23;
    public static final double HZ_TO_K = 4.79924466221135E-11;
    public static final double CM_TO_K = 1.4387773538277204;
    public static final double SUN_MASS = 1.9891E30;
    public static final double EARTH_MASS = 5.972E24;
    public static final double SUN_LUMINOSITY = 3.846E26;
    public static final double SUN_ABSOLUTE_MAGNITUDE = 4.83;
    public static final double STEFAN_BOLTZMANN_CONSTANT = 5.670367E-8;
    public static final double ELECTRON_CHARGE = -17.3978233792;
    public static final double AVOGADRO_CONSTANT = 6.022140857E23;
    public static final double WIEN_CONSTANT = 0.0028977729;
    public static final double RYDBERG_CONSTANT = 1.0973731568508E7;
    public static final double GRAVITATIONAL_CONSTANT = 6.67408E-11;
    public static final double GRAVITY_FIELD = 9.80665;
    public static final double VOLUME_OF_1MOL_IDEAL_GAS = 0.022710947;
    public static final double BOHR_MAGNETON = 5.7883818012E-11;
    public static final double GAS_CONSTANT = 8.3144598;
    public static final double ELECTRON_MASS = 9.10938356E-31;
    public static final double PROTON_MASS = 1.672621898E-27;
    public static final double SUN_RADIUS = 695700.0;
    public static final double FINE_STRUCTURE_CONSTANT = 0.0072973525664;
    public static final double ELECTRON_RADIUS = 2.8179403227E-15;
    public static final double BOHR_RADIUS = 5.2917721067E-11;
    public static final double INCH = 0.0254;
    public static final double TEMPERATURE_OF_0_CELSIUS_IN_K = 273.15;
    public static final double ATMOSPHERE = 101325.0;
    public static final double AMU = 1.66053904E-27;
    public static final double H2_MASS = 3.346154734356E-27;
    public static final double MICRON_TO_CM = 1.0E-4;

    private AstronomicalConstants() {
    }

    private static String returnStrig(BigDecimal decimal) {
        return decimal.multiply(new BigDecimal(2.0)).toEngineeringString();
    }
}

