/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.internal;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.prefab.celestialbody.ExPlanet;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeOrbit;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.rom.api.space.ExoPlanet;
import net.rom.api.space.ExoSystem;
import net.rom.exoplanets.Assets;
import net.rom.exoplanets.conf.ConfigCore;
import net.rom.exoplanets.internal.world.star.ExoStar;

public class AstroBuilder {
    public static final boolean REALISM = ConfigCore.enableRealism;
    private String modid;

    public AstroBuilder() {
    }

    public AstroBuilder(String modid) {
        this.setModid(modid);
    }

    public String getModid() {
        return this.modid;
    }

    public void setModid(String modid) {
        this.modid = modid;
    }

    public ExoStar buildExoStar(String starName, int temp, double mass, double radius) {
        ExoStar star = new ExoStar(starName);
        star.setStarName(starName);
        star.setSurfaceTemp(temp);
        star.setStarMass(mass);
        star.setStarRadius(radius);
        star.setSpectralClass();
        return star;
    }

    public ExoSystem buildSolarSystem(String name, ExoStar exoStar, Vector3 pos) {
        ExoSystem body = new ExoSystem(name, "milky_way");
        exoStar.setParentSolarSystem(body);
        body.setMainStar(exoStar);
        body.setMapPosition(pos);
        exoStar.setBodyIcon(Assets.getCelestialTexture(exoStar.getName()));
        return body;
    }

    public ExoPlanet buildExoPlanet(SolarSystem system, String name, Class<? extends WorldProvider> provider, int dimID, int tier, float phase, float distance) {
        ExoPlanet body = (ExoPlanet)new ExoPlanet(name).setParentSolarSystem(system);
        body.setPhaseShift(phase);
        body.setRingColorRGB(0.1f, 0.9f, 2.6f);
        body.setRelativeSize(1.0f);
        body.setBodyIcon(Assets.getCelestialTexture(name));
        body.addChecklistKeys(new String[]{"equipOxygenSuit"});
        return body;
    }

    public static ExPlanet registerExPlanet(SolarSystem system, String name, float distancefromcenter, IAdvancedSpace.ClassBody clazz) {
        ExPlanet body = new ExPlanet(name).setParentSolarSystem(system);
        body.setClassPlanet(clazz);
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setBodyIcon(Assets.getCelestialTexture(name));
        return body;
    }

    public void setBiomes(CelestialBody body, Biome ... biomes) {
        body.setBiomeInfo(biomes);
    }

    public void setAtmos(CelestialBody body, EnumAtmosphericGas ... gasses) {
        ((ExoPlanet)body).setAtmosGasses(gasses);
    }

    public static void setAtmosphere(CelestialBody body, EnumAtmosphericGas ... gasses) {
        boolean canBreathe = false;
        boolean canRain = false;
        boolean isCorr = false;
        float d = 0.0f;
        for (EnumAtmosphericGas enumAtmosphericGas : gasses) {
            d += 1.0f;
            body.atmosphereComponent(enumAtmosphericGas);
            if (enumAtmosphericGas == EnumAtmosphericGas.OXYGEN) {
                canBreathe = true;
            }
            if (enumAtmosphericGas == EnumAtmosphericGas.CO2) {
                canRain = true;
            }
            if (enumAtmosphericGas != EnumAtmosphericGas.METHANE) continue;
            isCorr = true;
        }
        body.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(canBreathe), canRain, isCorr, 0.0f, 0.0f, d));
    }

    public void setData(CelestialBody body, IAdvancedSpace.ClassBody clazz, float distance, float gravity, float orbit, int pressure, long day) {
        ((ExoPlanet)body).setClassBody(clazz);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distance, distance));
        body.setRelativeOrbitTime(orbit);
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        ((ExoPlanet)body).setPlanetGravity(gravity);
        ((ExoPlanet)body).setAtmosphericPressure(pressure);
        BodiesRegistry.setPlanetData((CelestialBody)body, (int)0, (long)day, (float)BodiesRegistry.calculateGravity((float)gravity), (boolean)false);
    }

    public void setExoData(CelestialBody body, float temp, float mass, float radius) {
        ((ExoPlanet)body).setPlanetTemp(temp);
        ((ExoPlanet)body).setPlanetMass(mass);
        ((ExoPlanet)body).setPlanetRadius(radius);
    }

    public void setNormalOrbit(CelestialBody body) {
        BodiesRegistry.setOrbitData((CelestialBody)body, (float)body.getPhaseShift(), (float)1.0f, (float)body.getRelativeOrbitTime());
    }

    public void setOrbit(CelestialBody body, float eccentricityX, float eccentricityY, float orbitOffsetX, float orbitOffsetY) {
        ((ExoPlanet)body).setOrbitEccentricity(eccentricityY, orbitOffsetX);
        ((ExoPlanet)body).setOrbitOffset(orbitOffsetX, orbitOffsetY);
        BodiesRegistry.setOrbitData((CelestialBody)body, (float)body.getPhaseShift(), (float)1.0f, (float)body.getRelativeOrbitTime(), (float)eccentricityX, (float)eccentricityY, (float)orbitOffsetX, (float)orbitOffsetY);
    }

    public Satellite buildSpaceStation(Planet parent, String color, Class<? extends WorldProvider> provider, int dimID, int dimIDStatic, float phase, float size, float distancefromcenter, float relativetime, boolean customStationIcon, @Nullable String bodyIcon) {
        Satellite body = new Satellite("spacestation." + parent.getUnlocalizedName().replace("planet.", ""));
        body.setParentBody(parent);
        body.setRelativeOrbitTime(relativetime);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        if (customStationIcon) {
            body.setBodyIcon(new ResourceLocation(this.getModid(), "textures/celestialbodies/spacestations/" + bodyIcon + ".png"));
        } else {
            body.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        }
        if (provider != null) {
            body.setTierRequired(parent.getTierRequirement());
            body.setDimensionInfo(dimID, dimIDStatic, provider);
            body.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        return body;
    }

    public Moon buildMoon(Planet parent, String name, int dimID, float size, float distancefromcenter, float relativetime) {
        Moon body = new Moon(name).setParentPlanet(parent);
        body.setRingColorRGB(0.8f, 0.0f, 0.0f);
        body.setRelativeSize(size);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setRelativeOrbitTime(relativetime);
        body.setBodyIcon(new ResourceLocation(this.getModid(), "textures/celestialbodies/moons/space_station.png"));
        GalaxyRegistry.registerMoon((Moon)body);
        return body;
    }

    public ExoPlanet buildSpecialUnreachable(String planetName, SolarSystem solarSystem, float randomPhase, float au) {
        ExoPlanet unreachable = (ExoPlanet)new ExoPlanet(planetName).setParentSolarSystem(solarSystem);
        unreachable.setDistanceFromCenter(au);
        unreachable.setPhaseShift(randomPhase);
        unreachable.setRelativeSize(1.0f);
        GalaxyRegistry.registerPlanet((Planet)unreachable);
        return unreachable;
    }

    public ExoPlanet buildUnreachablePlanet(String planetName, SolarSystem solarSystem, float randomPhase) {
        ExoPlanet unreachable = (ExoPlanet)new ExoPlanet(planetName).setParentSolarSystem(solarSystem);
        unreachable.setBodyIcon(Assets.getCelestialTexture(planetName));
        unreachable.setPhaseShift(randomPhase);
        unreachable.setRelativeSize(1.0f);
        unreachable.setRingColorRGB(0.8f, 0.0f, 0.0f);
        GalaxyRegistry.registerPlanet((Planet)unreachable);
        return unreachable;
    }

    public void registerSolarSystem(SolarSystem solarSystem) {
        GalaxyRegistry.registerSolarSystem((SolarSystem)solarSystem);
    }

    public void registerPlanet(Planet planet) {
        GalaxyRegistry.registerPlanet((Planet)planet);
    }

    public void registerMoon(Moon moon) {
        GalaxyRegistry.registerMoon((Moon)moon);
    }

    public void register(Object val) {
        if (val instanceof SolarSystem) {
            GalaxyRegistry.registerSolarSystem((SolarSystem)((SolarSystem)val));
        }
        if (val instanceof Planet) {
            GalaxyRegistry.registerPlanet((Planet)((Planet)val));
        }
        if (val instanceof Moon) {
            GalaxyRegistry.registerMoon((Moon)((Moon)val));
        }
    }

    public void registerTeleportType(Class<? extends WorldProvider> clazz, ITeleportType type) {
        GalacticraftRegistry.registerTeleportType(clazz, (ITeleportType)type);
    }

    public void registerRocketGui(Class<? extends WorldProvider> clazz, String resource) {
        GalacticraftRegistry.registerRocketGui(clazz, (ResourceLocation)new ResourceLocation(this.getModid() + ":textures/gui/rocket/" + resource + ".png"));
    }
}

