/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.init;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.rom.api.space.ExoSystem;
import net.rom.exoplanets.conf.ConfigSystems;
import net.rom.exoplanets.internal.AstroBuilder;
import net.rom.exoplanets.internal.world.star.ExoStar;

public class SolarSystems {
    private static BodiesData yzCetiStarData = StarData.MAIN_SEQUENCE_RED_DWARF;
    private static BodiesData wolf1061StarData = StarData.MAIN_SEQUENCE_RED_DWARF;
    private static BodiesData trappist1StarData = StarData.MAIN_SEQUENCE_RED_DWARF;
    private static BodiesData kepler1649starData = StarData.MAIN_SEQUENCE_ORANGE_DWARF;
    public static ExoStar yzCetiStar;
    public static ExoStar wolf1061Star;
    public static ExoStar trappist1Star;
    public static ExoStar kepler1649star;
    public static ExoSystem yzCeti;
    public static ExoSystem wolf1061;
    public static ExoSystem trappist1;
    public static ExoSystem kepler1649;
    public static boolean buildyzCeti;
    public static boolean buildwolf1061;
    public static boolean buildtrappist1;
    public static boolean buildkepler1649;
    static AstroBuilder b;

    public static void init() {
        SolarSystems.preBuild();
    }

    private static void preBuild() {
        if (buildyzCeti) {
            yzCetiStar = b.buildExoStar("yzcetistar", 3058, 0.13, 0.168);
            yzCeti = b.buildSolarSystem("YzCeti", yzCetiStar, SolarSystems.yzPos());
            yzCeti.setHabitableZoneStart(80.0f);
            yzCeti.setHabitableZoneEnd(120.0f);
        }
        if (buildwolf1061) {
            wolf1061Star = b.buildExoStar("wolf1061star", 3342, 0.294, 0.307);
            wolf1061 = b.buildSolarSystem("Wolf1061", wolf1061Star, SolarSystems.wolfPos());
            wolf1061.setHabitableZoneStart(50.0f);
            wolf1061.setHabitableZoneEnd(100.0f);
        }
        if (buildtrappist1) {
            trappist1Star = b.buildExoStar("trappist1star", 2511, 0.089, 0.121);
            trappist1 = b.buildSolarSystem("Trappist1", trappist1Star, SolarSystems.trapPos());
            trappist1.setHabitableZoneStart(75.0f);
            trappist1.setHabitableZoneEnd(115.0f);
        }
        if (buildkepler1649) {
            kepler1649star = b.buildExoStar("kepler1649star", 2150, 0.02, 0.23);
            kepler1649 = b.buildSolarSystem("Kepler1649", kepler1649star, SolarSystems.k1649Pos());
            kepler1649.setHabitableZoneStart(75.0f);
            kepler1649.setHabitableZoneEnd(115.0f);
        }
        SolarSystems.registerSolarSystems();
    }

    private static void registerSolarSystems() {
        if (buildyzCeti) {
            BodiesRegistry.registerBodyData((CelestialBody)yzCeti.getMainStar(), (BodiesData)yzCetiStarData);
            b.registerSolarSystem(yzCeti);
        }
        if (buildwolf1061) {
            wolf1061.setMapPosition(SolarSystems.wolfPos());
            BodiesRegistry.registerBodyData((CelestialBody)wolf1061.getMainStar(), (BodiesData)wolf1061StarData);
            b.registerSolarSystem(wolf1061);
        }
        if (buildtrappist1) {
            BodiesRegistry.registerBodyData((CelestialBody)trappist1.getMainStar(), (BodiesData)trappist1StarData);
            b.registerSolarSystem(trappist1);
        }
        if (buildkepler1649) {
            BodiesRegistry.registerBodyData((CelestialBody)kepler1649.getMainStar(), (BodiesData)kepler1649starData);
            b.registerSolarSystem(kepler1649);
        }
    }

    public static Vector3 yzPos() {
        return new Vector3(ConfigSystems.yzceti_map[0], ConfigSystems.yzceti_map[1], 0.0);
    }

    public static Vector3 wolfPos() {
        return new Vector3(ConfigSystems.wolf_map[0], ConfigSystems.wolf_map[1], 0.0);
    }

    public static Vector3 trapPos() {
        return new Vector3(ConfigSystems.trap_map[0], ConfigSystems.trap_map[1], 0.0);
    }

    public static Vector3 k1649Pos() {
        return new Vector3(ConfigSystems.k1649_map[0], ConfigSystems.k1649_map[1], 0.0);
    }

    static {
        buildyzCeti = !ConfigSystems.disable_yzceti_system;
        buildwolf1061 = !ConfigSystems.disable_yzceti_system;
        buildtrappist1 = !ConfigSystems.disable_yzceti_system;
        buildkepler1649 = !ConfigSystems.disable_yzceti_system;
        b = new AstroBuilder("exoplanets");
    }

    private static class StarData
    extends BodiesData {
        public static final StarData MAIN_SEQUENCE_RED_DWARF = new StarData(IAdvancedSpace.StarClass.DWARF, IAdvancedSpace.StarColor.RED);
        public static final StarData MAIN_SEQUENCE_ORANGE_DWARF = new StarData(IAdvancedSpace.StarClass.DWARF, IAdvancedSpace.StarColor.ORANGE);

        public StarData(IAdvancedSpace.StarClass clazz, IAdvancedSpace.StarColor color) {
            super(IAdvancedSpace.TypeBody.STAR);
            this.setStarClass(clazz);
            this.setStarColor(color);
        }
    }
}

