/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.content.block.fluid.BlockFluid;
import net.rom.exoplanets.util.CreativeExoTabs;

public class ExoFluids {
    public static Fluid fluidpressurized;
    public static BlockFluidBase fluidBlockMantle;
    private static final Map<Fluid, BlockFluidBase> fluidBlocks;
    private static final Map<BlockFluidBase, String> fluidBlockNames;

    public static void init() {
        fluidpressurized = ExoFluids.newFluid("pressurizedfluid", 1, 500, 80, 0);
        fluidBlockMantle = ExoFluids.registerFluidBlock(fluidpressurized, new BlockFluid(fluidpressurized, Material.field_151586_h), "pressurizedfluid");
    }

    private static Fluid newFluid(String name, int density, int viscosity, int temperature, int luminosity) {
        Fluid fluid = new Fluid(name, new ResourceLocation("exoplanets:blocks/" + name + "_still"), new ResourceLocation("exoplanets:blocks/" + name + "_flow")){

            public String getLocalizedName(FluidStack stack) {
                return ExoplanetsMod.translate.translate(this.unlocalizedName, new Object[0]);
            }
        };
        fluid.setDensity(density);
        fluid.setViscosity(viscosity);
        fluid.setTemperature(temperature);
        fluid.setLuminosity(luminosity);
        fluid.setUnlocalizedName("exoplanets." + name);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return fluid;
    }

    private static BlockFluidClassic registerFluidBlock(Fluid fluid, BlockFluidClassic block, String name) {
        String blockName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        ExoplanetsMod.REGISTRY.registerBlock(block, blockName);
        block.func_149663_c("exoplanets:" + blockName);
        block.func_149647_a(CreativeExoTabs.TERRAIN_CREATIVE_TABS);
        fluidBlocks.put(fluid, (BlockFluidBase)block);
        fluidBlockNames.put((BlockFluidBase)block, name);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void bakeModels() {
        for (Fluid fluid : fluidBlocks.keySet()) {
            BlockFluidBase block = fluidBlocks.get(fluid);
            Item item = Item.func_150898_a((Block)block);
            String name = fluidBlockNames.get(block);
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            final ModelResourceLocation fluidModelLocation = new ModelResourceLocation("exoplanets:" + name, "fluid");
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, stack -> fluidModelLocation);
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return fluidModelLocation;
                }
            });
        }
    }

    static {
        fluidBlocks = new HashMap<Fluid, BlockFluidBase>();
        fluidBlockNames = new HashMap<BlockFluidBase, String>();
    }
}

