/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.events;

import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.api.space.ExoSystem;
import net.rom.exoplanets.init.SolarSystems;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class HabitableZoneClientHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        ExoSystem system;
        if (renderEvent.celestialBody.equals((Object)SolarSystems.yzCeti.getMainStar())) {
            system = SolarSystems.yzCeti;
            this.RingRender(renderEvent, system);
        }
        if (renderEvent.celestialBody.equals((Object)SolarSystems.wolf1061.getMainStar())) {
            system = SolarSystems.wolf1061;
            this.RingRender(renderEvent, system);
        }
        if (renderEvent.celestialBody.equals((Object)SolarSystems.kepler1649.getMainStar())) {
            system = SolarSystems.kepler1649;
            this.RingRender(renderEvent, system);
        }
        if (renderEvent.celestialBody.equals((Object)SolarSystems.trappist1.getMainStar())) {
            system = SolarSystems.trappist1;
            this.RingRender(renderEvent, system);
        }
    }

    public void RingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, ExoSystem solarSystem) {
        float temp;
        int i;
        float max;
        Vector3f mapPos = solarSystem.getMapPosition().toVector3f();
        float xX = mapPos.x;
        float yY = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
            GL11.glColor4f((float)0.0f, (float)0.9f, (float)0.1f, (float)0.5f);
        } else {
            GL11.glColor4f((float)0.3f, (float)0.1f, (float)0.1f, (float)0.0f);
        }
        renderEvent.setCanceled(true);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        float min = solarSystem.getHabitableZoneStart();
        float x = max = solarSystem.getHabitableZoneEnd();
        float y = 0.0f;
        GL11.glBegin((int)2);
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xX), (float)(y + yY));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min;
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xX), (float)(y + yY));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)0.0f, (float)0.9f, (float)0.1f, (float)0.1f);
        GL11.glBegin((int)7);
        x = min;
        y = 0.0f;
        float x2 = max;
        float y2 = 0.0f;
        for (int i2 = 0; i2 < 90; ++i2) {
            GL11.glVertex2f((float)(x2 + xX), (float)(y2 + yY));
            GL11.glVertex2f((float)(x + xX), (float)(y + yY));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
            temp = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp + cos * y2;
            GL11.glVertex2f((float)(x + xX), (float)(y + yY));
            GL11.glVertex2f((float)(x2 + xX), (float)(y2 + yY));
        }
        GL11.glEnd();
    }
}

