/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.content.block.machine.container.ContainerMetalFurnace;
import net.rom.exoplanets.internal.StackHelper;
import net.rom.exoplanets.internal.tile.TileSidedInventoryExo;

public class TileEntityMetalFurnace
extends TileSidedInventoryExo
implements ITickable {
    public static final int COOK_TIME_NO_SECONDARY = 133;
    public static final int COOK_TIME_WITH_SECONDARY = 266;
    public static final int BONUS_DUST_MIN = 1;
    public static final int BONUS_DUST_MAX = 3;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT_1 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int SIZE_INVENTORY = 4;
    public static final Pattern REGEX_ITEM_MATCH = Pattern.compile("^(ingot|gem)");
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1, 2, 3};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;

    public List<String> getDebugLines() {
        String sep = "-----------------------";
        ArrayList list = Lists.newArrayList();
        list.add("DEBUG INFO:");
        list.add(sep);
        list.add("furnaceBurnTime = " + this.furnaceBurnTime);
        list.add("currentItemBurnTime = " + this.currentItemBurnTime);
        list.add("cookTime = " + this.cookTime);
        list.add("totalCookTime = " + this.totalCookTime);
        ItemStack output1 = this.getPrimaryOutput();
        ItemStack output2 = this.getSecondaryOutput();
        list.add("output1 = " + (output1.func_190926_b() ? "null" : output1.func_82833_r()));
        list.add("output2 = " + (output2.func_190926_b() ? "null" : output2.func_82833_r()));
        list.add("canSmelt = " + this.canSmelt());
        list.add(sep);
        list.add("COOK_TIME_NO_SECONDARY = 133");
        list.add("COOK_TIME_WITH_SECONDARY = 266");
        list.add("BONUS_NUGGETS_MIN = 1");
        list.add("BONUS_NUGGETS_MAX = 3");
        return list;
    }

    public int getCookTime() {
        return this.getSecondaryOutput().func_190926_b() ? 133 : 266;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        ItemStack current = this.func_70301_a(index);
        boolean flag = !current.func_190926_b() && !stack.func_190926_b() && stack.func_77969_a(current) && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)current);
        super.func_70299_a(index, stack);
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= 2) {
            return false;
        }
        if (index == 1) {
            return TileEntityMetalFurnace.isItemFuel(stack);
        }
        return true;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer player) {
        return new ContainerMetalFurnace(playerInventory, this);
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.func_70301_a(1);
            ItemStack input = this.func_70301_a(0);
            if (!this.isBurning() && (fuel.func_190926_b() || input.func_190926_b())) {
                if (!this.isBurning() && this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityMetalFurnace.getItemBurnTime(fuel);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!fuel.func_190926_b()) {
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                fuel = fuel.func_77973_b().getContainerItem(fuel);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                int meta = state.func_177230_c().func_176201_c(state);
                meta = this.isBurning() ? meta | 8 : meta & 7;
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177230_c().func_176203_a(meta));
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceBurnTime = compound.func_74765_d("BurnTime");
        this.cookTime = compound.func_74765_d("CookTime");
        this.totalCookTime = compound.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileEntityMetalFurnace.getItemBurnTime(this.func_70301_a(1));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        compound.func_74777_a("CookTime", (short)this.cookTime);
        compound.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        return compound;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public ItemStack getPrimaryOutput() {
        ItemStack inputStack = this.func_70301_a(0);
        if (inputStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(inputStack);
    }

    public ItemStack getSecondaryOutput() {
        ItemStack inputStack = this.func_70301_a(0);
        if (inputStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack outputPrimary = FurnaceRecipes.func_77602_a().func_151395_a(inputStack);
        if (outputPrimary.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int inputId : OreDictionary.getOreIDs((ItemStack)inputStack)) {
            String inputName = OreDictionary.getOreName((int)inputId);
            for (int outputId : OreDictionary.getOreIDs((ItemStack)outputPrimary)) {
                String outputName = OreDictionary.getOreName((int)outputId);
                if (!inputName.startsWith("ore") || !REGEX_ITEM_MATCH.matcher(outputName).find() || !(inputName = inputName.replaceFirst("ore", "")).equals(outputName = outputName.replaceFirst(REGEX_ITEM_MATCH.pattern(), ""))) continue;
                List<ItemStack> dust = StackHelper.getOres("dust" + inputName);
                if (!dust.isEmpty()) {
                    ItemStack result = dust.get(0).func_77946_l();
                    result.func_190920_e(1 + ExoplanetsMod.random.nextInt(3));
                    return result;
                }
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean canSmelt() {
        int maxSize2;
        boolean output2ClearOrSame;
        ItemStack inputStack = this.func_70301_a(0);
        if (inputStack.func_190926_b()) {
            return false;
        }
        ItemStack outputPrimary = this.getPrimaryOutput();
        ItemStack outputSecondary = this.getSecondaryOutput();
        if (!outputSecondary.func_190926_b()) {
            outputSecondary.func_190920_e(3);
        }
        ItemStack outputSlot1 = this.func_70301_a(2);
        ItemStack outputSlot2 = this.func_70301_a(3);
        if (outputPrimary.func_190926_b()) {
            return false;
        }
        if (outputSlot1.func_190926_b() && outputSlot2.func_190926_b()) {
            return true;
        }
        boolean output1ClearOrSame = outputSlot1.func_190926_b() || outputSlot1.func_77969_a(outputPrimary);
        boolean bl = output2ClearOrSame = outputSecondary.func_190926_b() || outputSlot2.func_190926_b() || outputSlot2.func_77969_a(outputSecondary);
        if (!output1ClearOrSame || !output2ClearOrSame) {
            return false;
        }
        int newSize1 = outputSlot1.func_190926_b() ? 0 : outputSlot1.func_190916_E() + outputPrimary.func_190916_E();
        int maxSize1 = outputPrimary.func_77976_d();
        int newSize2 = 0;
        int n = maxSize2 = outputSecondary.func_190926_b() ? 64 : outputSecondary.func_77976_d();
        if (!outputSecondary.func_190926_b()) {
            newSize2 = (outputSlot2.func_190926_b() ? 0 : outputSlot2.func_190916_E()) + outputSecondary.func_190916_E();
        }
        boolean flag1 = newSize1 <= this.func_70297_j_() && newSize1 <= maxSize1;
        boolean flag2 = newSize2 <= this.func_70297_j_() && newSize2 <= maxSize2;
        return flag1 && flag2;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack outputPrimary = this.getPrimaryOutput();
            ItemStack outputSecondary = this.getSecondaryOutput();
            ItemStack output1 = this.func_70301_a(2);
            ItemStack output2 = this.func_70301_a(3);
            if (output1.func_190926_b()) {
                output1 = outputPrimary.func_77946_l();
            } else if (output1.func_77973_b() == outputPrimary.func_77973_b()) {
                output1.func_190917_f(outputPrimary.func_190916_E());
            }
            this.func_70299_a(2, output1);
            if (!outputSecondary.func_190926_b()) {
                if (output2.func_190926_b()) {
                    output2 = outputSecondary.func_77946_l();
                } else if (output2.func_77973_b() == outputSecondary.func_77973_b()) {
                    output2.func_190917_f(outputSecondary.func_190916_E());
                }
                this.func_70299_a(3, output2);
            }
            ItemStack input = this.func_70301_a(0);
            ItemStack fuel = this.func_70301_a(1);
            if (input.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && input.func_77960_j() == 1 && fuel.func_77973_b() == Items.field_151133_ar) {
                this.func_70299_a(1, new ItemStack(Items.field_151131_as));
            }
            input.func_190918_g(1);
            this.func_70299_a(0, input);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityMetalFurnace.getItemBurnTime(stack) > 0;
    }

    @Override
    public String func_70005_c_() {
        return "container.exoplanets.metalfurnace.name";
    }

    public int func_70302_i_() {
        return 4;
    }
}

