/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.rom.api.crafting.recipe.alloyrefinery.AlloyRefineryRecipe;
import net.rom.api.crafting.recipe.alloyrefinery.AlloyRefineryRecipeObject;
import net.rom.exoplanets.content.block.machine.container.ContainerAlloyRefinery;
import net.rom.exoplanets.internal.tile.TileSidedInventoryExo;

public class TileEntityAlloyRefinery
extends TileSidedInventoryExo
implements ITickable {
    public static final float BURN_TIME_MULTI = 0.5f;
    public static final int[] SLOTS_INPUT = new int[]{0, 1, 2, 3};
    public static final int SLOT_FUEL = 4;
    public static final int SLOT_OUTPUT = 5;
    public static final int NUMBER_OF_SLOTS = 6;
    public static final int[] SLOTS_TOP = SLOTS_INPUT;
    public static final int[] SLOTS_BOTTOM = new int[]{5, 4};
    public static final int[] SLOTS_SIDES = new int[]{4};
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;

    public List<String> getDebugLines() {
        String sep = "-----------------------";
        ArrayList list = Lists.newArrayList();
        list.add("DEBUG INFO:");
        list.add(sep);
        list.add("furnaceBurnTime = " + this.furnaceBurnTime);
        list.add("currentItemBurnTime = " + this.currentItemBurnTime);
        list.add("cookTime = " + this.cookTime);
        list.add("totalCookTime = " + this.totalCookTime);
        ItemStack result = this.getSmeltingResult();
        list.add("result = " + (result.func_190926_b() ? "null" : result.func_82833_r()));
        list.add("canSmelt = " + this.canSmelt());
        list.add(sep);
        list.add("BURN_TIME_MULTI = 0.5");
        return list;
    }

    public int getCookTime() {
        AlloyRefineryRecipe recipe = AlloyRefineryRecipe.getMatchingRecipe(this.getInputStacks());
        return recipe == null ? 0 : recipe.getCookTime();
    }

    public static int getItemBurnTime(ItemStack stack) {
        return (int)((float)TileEntityFurnace.func_145952_a((ItemStack)stack) * 0.5f);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityAlloyRefinery.getItemBurnTime(stack) > 0;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public boolean canSmelt() {
        ItemStack result = this.getSmeltingResult();
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack outputSlot = this.func_70301_a(5);
        if (outputSlot.func_190926_b()) {
            return true;
        }
        if (!result.func_77969_a(outputSlot)) {
            return false;
        }
        int newOutputSize = outputSlot.func_190916_E() + result.func_190916_E();
        return newOutputSize <= this.func_70297_j_() && newOutputSize <= result.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            AlloyRefineryRecipeObject[] inputList;
            ItemStack output = this.getSmeltingResult();
            ItemStack slotOutput = this.func_70301_a(5);
            if (slotOutput.func_190926_b()) {
                this.func_70299_a(5, output);
            } else if (slotOutput.func_77969_a(output)) {
                slotOutput.func_190917_f(output.func_190916_E());
            }
            AlloyRefineryRecipe recipe = AlloyRefineryRecipe.getMatchingRecipe(this.getInputStacks());
            if (recipe == null) {
                return;
            }
            block0: for (AlloyRefineryRecipeObject recipeObject : inputList = recipe.getInputs()) {
                for (int i = 0; i < SLOTS_INPUT.length; ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (stack.func_190926_b() || !recipeObject.matches(stack)) continue;
                    stack.func_190918_g(recipeObject.getMatchingStack(stack).func_190916_E());
                    if (!stack.func_190926_b()) continue block0;
                    stack = stack.func_77973_b().getContainerItem(stack);
                    continue block0;
                }
            }
        }
    }

    public ItemStack getSmeltingResult() {
        AlloyRefineryRecipe recipe = AlloyRefineryRecipe.getMatchingRecipe(this.getInputStacks());
        return recipe == null ? ItemStack.field_190927_a : recipe.getOutput();
    }

    public NonNullList<ItemStack> getInputStacks() {
        NonNullList result = NonNullList.func_191196_a();
        for (int i = 0; i < SLOTS_INPUT.length; ++i) {
            result.add((Object)this.func_70301_a(i));
        }
        return result;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(this.func_70301_a(index)) && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.func_70301_a(index));
        super.func_70299_a(index, stack);
        if (index < SLOTS_INPUT.length && !flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 4) {
            return TileEntityAlloyRefinery.isItemFuel(stack);
        }
        if (index < SLOTS_INPUT.length) {
            return AlloyRefineryRecipe.isValidIngredient(stack);
        }
        return true;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    @Override
    public String func_70005_c_() {
        return "container.exoplanets.alloyrefinery.name";
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 4) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer player) {
        return new ContainerAlloyRefinery(playerInventory, this);
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack slotFuel = this.func_70301_a(4);
            if (!this.isBurning() && slotFuel.func_190926_b()) {
                if (!this.isBurning() && this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityAlloyRefinery.getItemBurnTime(slotFuel);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!slotFuel.func_190926_b()) {
                            slotFuel.func_190918_g(1);
                            if (slotFuel.func_190926_b()) {
                                slotFuel = slotFuel.func_77973_b().getContainerItem(slotFuel);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        if (this.totalCookTime > 0) {
                            this.smeltItem();
                            flag1 = true;
                        }
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                int meta = state.func_177230_c().func_176201_c(state);
                meta = this.isBurning() ? meta | 8 : meta & 7;
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177230_c().func_176203_a(meta));
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceBurnTime = compound.func_74765_d("BurnTime");
        this.cookTime = compound.func_74765_d("CookTime");
        this.totalCookTime = compound.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileEntityAlloyRefinery.getItemBurnTime(this.func_70301_a(4));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        compound.func_74777_a("CookTime", (short)this.cookTime);
        compound.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        return compound;
    }

    public int func_70302_i_() {
        return 6;
    }
}

