/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.rom.exoplanets.content.EnumAlloy;
import net.rom.exoplanets.content.EnumMetal;
import net.rom.exoplanets.content.IMetal;
import net.rom.exoplanets.content.item.ItemBaseMetal;
import net.rom.exoplanets.internal.RecipeBuilder;

public class ItemCraftingItem
extends ItemBaseMetal {
    private final String craftingItemName;
    private final boolean isAlloy;
    private final boolean isGear;
    private final boolean isSheet;

    public ItemCraftingItem(String type, boolean isAlloy) {
        super(type, type);
        this.craftingItemName = type;
        this.isAlloy = isAlloy;
        this.isGear = "gear".equals(type);
        this.isSheet = "sheet".equals(type);
    }

    @Override
    public List<IMetal> getMetals(Item item) {
        ArrayList metals = Lists.newArrayList();
        if (!this.isAlloy) {
            metals.addAll(Arrays.asList(EnumMetal.values()));
            return metals;
        }
        metals.addAll(Arrays.asList(EnumAlloy.values()));
        return metals;
    }

    @Override
    public void addRecipes(RecipeBuilder recipes) {
        String mat;
        if (this.isGear) {
            for (IMetal metal : this.getMetals(this)) {
                ItemStack gear = metal.getSheet();
                for (String metalName : metal.getMetalNames()) {
                    mat = "ingot" + metalName;
                    recipes.addShapedOre("gear_" + metalName, gear, " m ", "mim", " m ", Character.valueOf('m'), mat, Character.valueOf('i'), "ingotIron");
                }
            }
        }
        if (this.isSheet) {
            for (IMetal metal : this.getMetals(this)) {
                ItemStack sheet = metal.getSheet();
                for (String metalName : metal.getMetalNames()) {
                    mat = "ingot" + metalName;
                    recipes.addShapedOre("sheet_" + metalName, sheet, " m ", "mim", " m ", Character.valueOf('m'), mat, Character.valueOf('i'), "ingotIron");
                }
            }
        }
    }

    @Override
    public void addOreDict() {
        super.addOreDict();
        if (!this.isAlloy) {
            OreDictionary.registerOre((String)(this.oreDictPrefix + "Aluminum"), (ItemStack)new ItemStack((Item)this, 1, EnumMetal.ALUMINIUM.meta));
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        for (IMetal metal : this.getMetals(this)) {
            if (metal.getMeta() != stack.func_77952_i()) continue;
            return super.func_77658_a().replaceFirst("metal|alloy", "") + metal.func_176610_l();
        }
        return super.func_77667_c(stack);
    }
}

